% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilFigureOfMerit.R
\name{UtilFigureOfMerit}
\alias{UtilFigureOfMerit}
\title{Calculate empirical figures of merit (FOMs) for specified dataset}
\usage{
UtilFigureOfMerit(dataset, FOM = "wAFROC", FPFValue = 0.2)
}
\arguments{
\item{dataset}{The dataset to be analyzed, \code{\link{RJafroc-package}}}

\item{FOM}{The figure of merit; the default is \code{"wAFROC"}}

\item{FPFValue}{Only needed for \code{LROC} data \strong{and} FOM = "PCL" or "ALROC";
where to evaluate a partial curve based figure of merit. The default is 0.2.}
}
\value{
An \code{c(I, J)} dataframe, where the row names are \code{modalityID}'s of the 
   treatments and column names are the \code{readerID}'s of the readers.
}
\description{
Calculate the specified empirical figure of merit
   for each treatment-reader combination in the 
   ROC, FROC, ROI or LROC dataset
}
\details{
The allowed FOMs depend on the \code{dataType} field of the 
   \code{dataset} object.  

   \strong{For \code{dataset$descriptions$design = "SPLIT-PLOT-C"}, end-point based 
   FOMs (e.g., "MaxLLF") are not allowed}.
   \strong{For \code{dataset$descriptions$type = "ROC"} only \code{FOM = "Wilcoxon"} is allowed}.
   \strong{For \code{dataset$descriptions$type = "FROC"} the following FOMs are allowed}:
   \itemize{ 
   \item \code{FOM = "AFROC1"} (use only if zero normal cases)
   \item \code{FOM = "AFROC"} 
   \item \code{FOM = "wAFROC1"} (use only if zero normal cases)
   \item \code{FOM = "wAFROC"} (the default) 
   \item \code{FOM = "HrAuc"} 
   \item \code{FOM = "SongA1"} 
   \item \code{FOM = "SongA2"}  
   \item \code{FOM = "HrSe"} (an example of an end-point based FOM)
   \item \code{FOM = "HrSp"} (another example)
   \item \code{FOM = "MaxLLF"} (do:)
   \item \code{FOM = "MaxNLF"} (do:)
   \item \code{FOM = "MaxNLFAllCases"} (do:) 
   \item \code{FOM = "ExpTrnsfmSp"}  
   } 
   \code{"MaxLLF"}, \code{"MaxNLF"} and \code{"MaxNLFAllCases"}
   correspond to ordinate, and abscissa, respectively, of the highest point 
   on the FROC operating characteristic obtained by counting all the marks. 
   The \code{"ExpTrnsfmSp"} FOM is described in the paper by Popescu. 
   Given the large number of FOMs possible with FROC data, it is appropriate 
   to make a recommendation: \strong{it is recommended that one use the wAFROC FOM
   whenever possible.}
   
   For \strong{\code{dataType = "ROI"} dataset only \code{FOM = "ROI"} is allowed}.
   
   For \strong{\code{dataType = "LROC"}} dataset the following FOMs are allowed:
   \itemize{
   \item \code{FOM = "Wilcoxon"} for ROC data inferred from LROC data 
   \item \code{FOM = "PCL"} the probability of correct localization at specified \code{FPFValue}
   \item \code{FOM = "ALROC"} the area under the LROC from zero to specified \code{FPFValue} 
   }
   \code{FPFValue} The FPF at which to evaluate \code{PCL} or \code{ALROC}; 
      the default is 0.2; only needed for LROC data.
}
\examples{
UtilFigureOfMerit(dataset02, FOM = "Wilcoxon") # ROC data
UtilFigureOfMerit(DfFroc2Roc(dataset01), FOM = "Wilcoxon") # FROC dataset, converted to ROC
UtilFigureOfMerit(dataset01) # FROC dataset, default wAFROC FOM
UtilFigureOfMerit(datasetCadLroc, FOM = "Wilcoxon") #LROC data
UtilFigureOfMerit(datasetCadLroc, FOM = "PCL") #LROC data
UtilFigureOfMerit(datasetCadLroc, FOM = "ALROC") #LROC data
UtilFigureOfMerit(datasetROI, FOM = "ROI") #ROI data
\donttest{ # these are meant to illustrate conditions which will throw an error
## UtilFigureOfMerit(dataset02, FOM = "wAFROC") #error
## UtilFigureOfMerit(dataset01, FOM = "Wilcoxon") #error
}

}
\references{
Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 

Chakraborty DP, Berbaum KS (2004) Observer studies involving detection and localization: modeling, analysis, and validation, 
Medical Physics, 31(8), 1--18.

Song T, Bandos AI, Rockette HE, Gur D (2008) On comparing methods for discriminating between actually negative and actually positive subjects 
with FROC type data, Medical Physics 35 1547--1558.

Popescu LM (2011) Nonparametric signal detectability evaluation using an exponential transformation of the FROC curve, 
Medical Physics, 38(10), 5690. 

Obuchowski NA, Lieber ML, Powell KA (2000) Data Analysis for Detection and Localization of Multiple Abnormalities 
with Application to Mammography, Acad Radiol, 7:7 553--554.

Swensson RG (1996) Unified measurement of observer performance in detecting and localizing target objects on images, 
Med Phys 23:10, 1709--1725.
}
