% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{datasetBinned125}
\alias{datasetBinned125}
\title{Binned dataset suitable for checking \code{\link{FitCorCbm}}; seed = 125}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1, 1:2, 1:10000, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1, 1:2, 1:5000, 1], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:5000], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:5000, 1] , numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:5000, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "datasetBinned125", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "SIM-CORCBM-SEED-125", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, NA, truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL-X-MOD", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr "1", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr [1:2] "1" "2", reader labels}
}
}
\usage{
datasetBinned125
}
\description{
A binned dataset suitable for analysis by \code{\link{FitCorCbm}}. It was generated by
   \code{\link{DfCreateCorCbmDataset}} by setting the \code{seed} variable to 125. 
   Otherwise similar to \code{\link{datasetBinned123}}.
}
\examples{
str(datasetBinned125)

}
\references{
Zhai X, Chakraborty DP (2017). A bivariate contaminated binormal model for robust 
   fitting of proper ROC curves to a pair of correlated, possibly degenerate, 
   ROC datasets. Medical Physics. 44(6):2207--2222.
}
\keyword{datasets}
