% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpol.R
\name{Interpolation}
\alias{Interpolation}
\alias{interpol1Dfun}
\alias{interpol2Dfun}
\alias{splinefun,ANY,advector,ANY,missing-method}
\alias{splinefun,advector,missing,ANY,missing-method}
\title{Interpolation}
\usage{
interpol1Dfun(z, xlim = c(1, length(z)), ...)

interpol2Dfun(z, xlim = c(1, nrow(z)), ylim = c(1, ncol(z)), ...)

\S4method{splinefun}{ANY,advector,ANY,missing}(x, y, method = c("fmm", "periodic", "natural"))

\S4method{splinefun}{advector,missing,ANY,missing}(x, method = c("fmm", "periodic", "natural"))
}
\arguments{
\item{z}{Matrix to be interpolated}

\item{xlim}{Domain of x}

\item{...}{Configuration parameters}

\item{ylim}{Domain of y}

\item{x}{spline x coordinates}

\item{y}{spline y coordinates}

\item{method}{Same as for the stats version, however only the three first are available.}
}
\value{
function of x.

function of x and y.
}
\description{
Some interpolation methods are available to be used as part of 'RTMB' objective functions.
}
\details{
\code{interpol1Dfun} and \code{interpol2Dfun} are kernel smoothers useful in the case where you need a 3rd order \emph{smooth} representation of a \emph{data} vector or matrix.
A typical use case is when a high-resolution map needs to be accessed along a random effect trajectory.
Both 1D and 2D cases accept an 'interpolation radius' parameter (default R=2) controlling the degree of smoothness. Note, that only the value R=1 will match the data exactly, while higher radius trades accuracy for smoothness. Note also that these smoothers do not attempt to extrapolate: The returned value will be \code{NaN} outside the valid range (\code{xlim} / \code{ylim}).

\code{splinefun} imitates the corresponding \code{stats} function. The AD implementation (in contrast to \code{interpol1Dfun}) works for parameter dependent y-coordinates.
}
\section{Functions}{
\itemize{
\item \code{interpol1Dfun()}: Construct a kernel smoothed representation of a vector.

\item \code{interpol2Dfun()}: Construct a kernel smoothed representation of a matrix.

\item \code{splinefun(x = ANY, y = advector, method = ANY, ties = missing)}: Construct a spline function.

\item \code{splinefun(x = advector, y = missing, method = ANY, ties = missing)}: Construct a spline function.

}}
\examples{
## ======= interpol1D
## R=1 => exact match of observations
f <- interpol1Dfun(sin(1:10), R=1)
layout(t(1:2))
plot(sin(1:10))
plot(f, 1, 10, add=TRUE)
title("R=1")
F <- MakeTape(f, 0)
F3 <- F$jacfun()$jacfun()$jacfun()
plot(Vectorize(F3), 1, 10)
title("3rd derivative")
## ======= interpol2D
## R=1 => exact match of observations
f <- interpol2Dfun(volcano, xlim=c(0,1), ylim=c(0,1), R=1)
f(0,0) == volcano[1,1]   ## Top-left corner
f(1,1) == volcano[87,61] ## Bottom-right corner
## R=2 => trades accuracy for smoothness
f <- interpol2Dfun(volcano, xlim=c(0,1), ylim=c(0,1), R=2)
f(0,0) - volcano[1,1]    ## Error Top-left corner
F <- MakeTape(function(x) f(x[1],x[2]), c(.5,.5))
## ======= splinefun
T <- MakeTape(function(x){
   S <- splinefun(sin(x))
   S(4:6)
}, 1:10)
}
