% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/halfnorm.start.limits.R
\name{halfnorm.start.limits}
\alias{halfnorm.start.limits}
\title{Start and limit values for halfnorm distance function}
\usage{
halfnorm.start.limits(ml)
}
\arguments{
\item{ml}{Either a Rdistance 'model frame' or an Rdistance 
'fitted object'.  Both are of class "dfunc". 
Rdistance 'model frames' are lists containing components 
necessary to estimate a distance function, but no estimates. 
Rdistance 'model frames' are typically
produced by calls to \code{\link{parseModel}}. 
Rdistance 'fitted objects'
are typically produced by calls to \code{\link{dfuncEstim}}.
'Fitted objects' are 'model frames'
with additional components such as the parameters estimates, 
log likelihood value, convergence information, and the variance-
covariance matrix of the parameters.}
}
\value{
A list containing the following components
  \item{start}{Vector of starting values for parameters of the likelihood and expansion terms. }
  \item{lowlimit}{Vector of lower limits for the likelihood parameters and expansion terms.}
  \item{uplimit}{Vector of upper limits for the likelihood parameters and expansion terms.}
  \item{names}{Vector of names for the likelihood parameters and expansion terms.}
  
The length of each vector in the return is:
  \code{(Num expansions) + 1 + 1*(like \%in\% c("hazrate")) + (Num Covars)}.
}
\description{
Compute starting values and limits for the half normal distance
function.
}
