% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testdata.r
\docType{data}
\name{testdata}
\alias{testdata}
\title{Reliability Test Data}
\format{
@format ## \code{testdata}
A data frame with 25 rows and 6 variables:
\describe{
\item{LRU}{The Line Replaceable Unit identifier (G1 or G2).}
\item{Cum_ETI}{Cumulative Equivalent Test Hours (ETI).}
\item{Failure_Count}{Cumulative number of failures observed.}
\item{Cum_MTBF}{Cumulative Mean Time Between Failures (MTBF).}
\item{Report_No}{Report number associated with the failure.}
\item{Flag}{A flag indicating special conditions or notes.}
\item{Cause}{Cause of the failure (e.g., D for Design, M for Manufacturing, R for Random, NR for No Report).}
}
@usage data(testdata)
}
\source{
\url{https://apps.dtic.mil/sti/tr/pdf/ADA176128.pdf}
}
\usage{
testdata
}
\description{
A dataset containing example reliability test data from the military report
"Reliability Growth Prediction" (1986) by The Analytical Sciences Corporation.
This dataset includes cumulative ETI, failure counts, cumulative MTBF, report
numbers, flags, and causes for two different LRUs (G1 and G2).
}
\examples{
data(testdata)
head(testdata)
summary(testdata)
str(testdata)

}
\keyword{datasets}
