% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{checkPath}
\alias{checkPath}
\alias{checkPath,character,logical-method}
\alias{checkPath,character,missing-method}
\alias{checkPath,NULL,ANY-method}
\alias{checkPath,missing,ANY-method}
\title{Check directory path}
\usage{
checkPath(path, create)

\S4method{checkPath}{character,logical}(path, create)

\S4method{checkPath}{character,missing}(path)

\S4method{checkPath}{`NULL`,ANY}(path)

\S4method{checkPath}{missing,ANY}()
}
\arguments{
\item{path}{A character string corresponding to a directory path.}

\item{create}{A logical indicating whether the path should
be created if it does not exist. Default is \code{FALSE}.}
}
\value{
Character string denoting the cleaned up filepath.
}
\description{
Checks the specified path to a directory for formatting consistencies,
such as trailing slashes, etc.
}
\note{
This will not work for paths to files.
To check for existence of files, use \code{file.exists()}.
To normalize a path to a file, use \code{normPath()} or \code{normalizePath()}.
}
\examples{
## normalize file paths
paths <- list("./aaa/zzz",
              "./aaa/zzz/",
              ".//aaa//zzz",
              ".//aaa//zzz/",
              ".\\\\\\\\aaa\\\\\\\\zzz",
              ".\\\\\\\\aaa\\\\\\\\zzz\\\\\\\\",
              file.path(".", "aaa", "zzz"))

checked <- normPath(paths)
length(unique(checked)) ## 1; all of the above are equivalent

## check to see if a path exists
tmpdir <- file.path(tempdir(), "example_checkPath")

dir.exists(tmpdir) ## FALSE
tryCatch(checkPath(tmpdir, create = FALSE), error = function(e) FALSE) ## FALSE

checkPath(tmpdir, create = TRUE)
dir.exists(tmpdir) ## TRUE

unlink(tmpdir, recursive = TRUE) # clean up
}
\seealso{
\code{\link[=file.exists]{file.exists()}}, \code{\link[=dir.create]{dir.create()}}.
}
