\name{mixmodCompositeModel}
\alias{mixmodCompositeModel}
\title{Create an instance of the [\code{\linkS4class{CompositeModel}}] class}
\usage{
  mixmodCompositeModel(listModels = NULL,
    free.proportions = TRUE, equal.proportions = TRUE,
    variable.independency = NULL,
    component.independency = NULL)
}
\arguments{
  \item{listModels}{a list of characters containing a list
  of models. It is optional.}

  \item{free.proportions}{logical to include models with
  free proportions. Default is TRUE.}

  \item{equal.proportions}{logical to include models with
  equal proportions. Default is TRUE.}

  \item{variable.independency}{logical to include models
  where \eqn{[\varepsilon_k^j]} is independent of the
  variable \eqn{j}. Optionnal.}

  \item{component.independency}{logical to include models
  where \eqn{[\varepsilon_k^j]} is independent of the
  component \eqn{k}. Optionnal.}
}
\value{
  an object of [\code{\linkS4class{CompositeModel}}] which
  contains some of the 40 heterogeneous Models:
  \tabular{rlllll}{ Model \tab Prop. \tab Var. \tab Comp.
  \tab Volume \tab Shape \cr Heterogeneous_p_E_L_B \tab
  Equal \tab TRUE \tab TRUE \tab Equal \tab Equal \cr
  Heterogeneous_p_E_Lk_B \tab \tab TRUE \tab TRUE \tab Free
  \tab Equal \cr Heterogeneous_p_E_L_Bk \tab \tab TRUE \tab
  TRUE \tab Equal \tab Free \cr Heterogeneous_p_E_Lk_Bk
  \tab \tab TRUE \tab TRUE \tab Free \tab Free \cr
  Heterogeneous_p_Ek_L_B \tab \tab TRUE \tab FALSE \tab
  Equal \tab Equal \cr Heterogeneous_p_Ek_Lk_B \tab \tab
  TRUE \tab FALSE \tab Free \tab Equal \cr
  Heterogeneous_p_Ek_L_Bk \tab \tab TRUE \tab FALSE \tab
  Equal \tab Free \cr Heterogeneous_p_Ek_Lk_Bk \tab \tab
  TRUE \tab FALSE \tab Free \tab Free \cr
  Heterogeneous_p_Ej_L_B \tab \tab FALSE \tab TRUE \tab
  Equal \tab Equal \cr Heterogeneous_p_Ej_Lk_B \tab \tab
  FALSE \tab TRUE \tab Free \tab Equal \cr
  Heterogeneous_p_Ej_L_Bk \tab \tab FALSE \tab TRUE \tab
  Equal \tab Free \cr Heterogeneous_p_Ej_Lk_Bk \tab \tab
  FALSE \tab TRUE \tab Free \tab Free \cr
  Heterogeneous_p_Ekj_L_B \tab \tab FALSE \tab FALSE \tab
  Equal \tab Equal \cr Heterogeneous_p_Ekj_Lk_B \tab \tab
  FALSE \tab FALSE \tab Free \tab Equal \cr
  Heterogeneous_p_Ekj_L_Bk \tab \tab FALSE \tab FALSE \tab
  Equal \tab Free \cr Heterogeneous_p_Ekj_Lk_Bk \tab \tab
  FALSE \tab FALSE \tab Free \tab Free \cr
  Heterogeneous_p_Ekjh_L_B \tab \tab FALSE \tab FALSE \tab
  Equal \tab Equal \cr Heterogeneous_p_Ekjh_Lk_B \tab \tab
  FALSE \tab FALSE \tab Free \tab Equal \cr
  Heterogeneous_p_Ekjh_L_Bk \tab \tab FALSE \tab FALSE \tab
  Equal \tab Free \cr Heterogeneous_p_Ekjh_Lk_Bk \tab \tab
  FALSE \tab FALSE \tab Free \tab Free \cr
  Heterogeneous_pk_E_L_B \tab Free \tab TRUE \tab TRUE \tab
  Equal \tab Equal \cr Heterogeneous_pk_E_Lk_B \tab \tab
  TRUE \tab TRUE \tab Free \tab Equal \cr
  Heterogeneous_pk_E_L_Bk \tab \tab TRUE \tab TRUE \tab
  Equal \tab Free \cr Heterogeneous_pk_E_Lk_Bk \tab \tab
  TRUE \tab TRUE \tab Free \tab Free \cr
  Heterogeneous_pk_Ek_L_B \tab \tab TRUE \tab FALSE \tab
  Equal \tab Equal \cr Heterogeneous_pk_Ek_Lk_B \tab \tab
  TRUE \tab FALSE \tab Free \tab Equal \cr
  Heterogeneous_pk_Ek_L_Bk \tab \tab TRUE \tab FALSE \tab
  Equal \tab Free \cr Heterogeneous_pk_Ek_Lk_Bk \tab \tab
  TRUE \tab FALSE \tab Free \tab Free \cr
  Heterogeneous_pk_Ej_L_B \tab \tab FALSE \tab TRUE \tab
  Equal \tab Equal \cr Heterogeneous_pk_Ej_Lk_B \tab \tab
  FALSE \tab TRUE \tab Free \tab Equal \cr
  Heterogeneous_pk_Ej_L_Bk \tab \tab FALSE \tab TRUE \tab
  Equal \tab Free \cr Heterogeneous_pk_Ej_Lk_Bk \tab \tab
  FALSE \tab TRUE \tab Free \tab Free \cr
  Heterogeneous_pk_Ekj_L_B \tab \tab FALSE \tab FALSE \tab
  Equal \tab Equal \cr Heterogeneous_pk_Ekj_Lk_B \tab \tab
  FALSE \tab FALSE \tab Free \tab Equal \cr
  Heterogeneous_pk_Ekj_L_Bk \tab \tab FALSE \tab FALSE \tab
  Equal \tab Free \cr Heterogeneous_pk_Ekj_Lk_Bk \tab \tab
  FALSE \tab FALSE \tab Free \tab Free \cr
  Heterogeneous_pk_Ekjh_L_B \tab \tab FALSE \tab FALSE \tab
  Equal \tab Equal \cr Heterogeneous_pk_Ekjh_Lk_B \tab \tab
  FALSE \tab FALSE \tab Free \tab Equal \cr
  Heterogeneous_pk_Ekjh_L_Bk \tab \tab FALSE \tab FALSE
  \tab Equal \tab Free \cr Heterogeneous_pk_Ekjh_Lk_Bk \tab
  \tab FALSE \tab FALSE \tab Free \tab Free \cr }
}
\description{
  Define a list of heterogeneous model to test in MIXMOD.
}
\details{
  In heterogeneous case, Gaussian model can only belong to
  the diagonal family. We assume that the variance matrices
  \eqn{\Sigma_{k}} are diagonal. In the parameterization,
  it means that the orientation matrices \eqn{D_{k}} are
  permutation matrices. We write
  \eqn{\Sigma_{k}=\lambda_{k}B_{k}} where \eqn{B_{k}} is a
  diagonal matrix with \eqn{| B_{k}|=1}.  This particular
  parameterization gives rise to 4 models: \eqn{[\lambda
  B]}, \eqn{[\lambda_{k}B]}, \eqn{[\lambda B_{k}]} and
  \eqn{[\lambda_{k}B_{k}]}. The multinomial distribution is
  associated to the \eqn{j}th variable of the \eqn{k}th
  component is reparameterized by a center \eqn{a_k^j} and
  the dispersion \eqn{\varepsilon_k^j} around this center.
  Thus, it allows us to give an interpretation similar to
  the center and the variance matrix used for continuous
  data in the Gaussian mixture context. In the following,
  this model will be denoted by \eqn{[\varepsilon_k^j]}. In
  this context, three other models can be easily deduced.
  We note \eqn{[\varepsilon_k]} the model where
  \eqn{\varepsilon_k^j} is independent of the variable
  \eqn{j}, \eqn{[\varepsilon^j]} the model where
  \eqn{\varepsilon_k^j} is independent of the component
  \eqn{k} and, finally, \eqn{[\varepsilon]} the model where
  \eqn{\varepsilon_k^j} is independent of both the variable
  $j$ and the component \eqn{k}.  In order to maintain some
  unity in the notation, we will denote also
  \eqn{[\varepsilon_k^{jh}]} the most general model
  introduced at the previous section.
}
\examples{
mixmodCompositeModel()
  # composite models with equal proportions
  mixmodCompositeModel(free.proportions=FALSE)
  # composite models with equal proportions and independent of the variable
  mixmodCompositeModel(free.proportions=FALSE, variable.independency=TRUE)
  # composite models with a pre-defined list
  mixmodCompositeModel( listModels=c("Heterogeneous_pk_Ekjh_L_Bk","Heterogeneous_pk_Ekjh_Lk_B") )
}
\author{
  Florent Langrognet and Remi Lebret and Christian Poli and Serge Iovleff,
  with contributions from C. Biernacki and G. Celeux and G.
  Govaert \email{contact@mixmod.org}
}
\references{
  C. Biernacki, G. Celeux, G. Govaert, F. Langrognet.
  "Model-Based Cluster and Discriminant Analysis with the
  MIXMOD Software". Computational Statistics and Data
  Analysis, vol. 51/2, pp. 587-600. (2006)
}

