% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{dnldGADMCtryShpZip}
\alias{dnldGADMCtryShpZip}
\title{Download a country's polygon RDS files from \url{http://gadm.org}}
\usage{
dnldGADMCtryShpZip(ctryCode, gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"),
  downloadMethod = pkgOptions("downloadMethod"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{The ISO3 ctryCode of the country polygon to download}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{downloadMethod}{The method used to download polygons}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
TRUE/FALSE Success/Failure of the download
}
\description{
Download a country's polygon RDS files from \url{http://gadm.org} and
    combine them into one RDS to match other polygon downloads
}
\examples{
\dontrun{
 Rnightlights:::dnldCtryShpZip("KEN", "3.6", "shpZip")
}

}
