% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanagement.R
\name{pre_comput_NN}
\alias{pre_comput_NN}
\title{pre_comput_NN: Precompute quantities for SLGP basis evaluation with nearest-neighbor interpolation}
\usage{
pre_comput_NN(
  normalizedData,
  predictorNames,
  responseName,
  nIntegral = 101,
  nDiscret = 51
)
}
\arguments{
\item{normalizedData}{A normalized data frame (values in \eqn{[0,1]}).}

\item{predictorNames}{Character vector of covariate names.}

\item{responseName}{Name of the response variable.}

\item{nIntegral}{Number of grid points for discretizing the response domain.}

\item{nDiscret}{Number of grid points for discretizing the covariate domain.}
}
\value{
A list of intermediate quantities used in SLGP evaluation:
\itemize{
\item \code{nodes}: grid of response × covariates,
\item \code{indNodesToIntegral}: response bin indices,
\item \code{indSamplesToNodes}: sample-to-node index mapping,
\item \code{weightSamplesToNodes}: equal weights for NN interpolation.
}
}
\description{
Computes intermediate quantities for evaluating SLGP basis functions using
Nearest Neighbor (NN) interpolation over a regular grid in the normalized domain.
}
\keyword{internal}
