% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-plate.R
\name{plot_layout}
\alias{plot_layout}
\title{Plot layout of a 96-well plate}
\usage{
plot_layout(plate, plot_legend = TRUE)
}
\arguments{
\item{plate}{The plate object with the layout information}

\item{plot_legend}{Logical indicating if the legend should be plotted}
}
\value{
A ggplot object
}
\description{
This function plots the layout of a 96-well plate using a colour to represent the sample types. \cr \cr
If the plot window is resized, it's best to re-run the function to adjust the scaling.
Sometimes, the whole layout may be shifted when a legend is plotted. It's best to stretch the window, and everything will be adjusted automatically.
}
\examples{
plate_filepath <- system.file("extdata", "CovidOISExPONTENT_CO.csv",
  package = "SerolyzeR", mustWork = TRUE
)
layout_filepath <- system.file("extdata", "CovidOISExPONTENT_CO_layout.xlsx",
  package = "SerolyzeR", mustWork = TRUE
)
plate <- read_luminex_data(plate_filepath, layout_filepath)
plot_layout(plate = plate, plot_legend = TRUE)

}
