% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{Fragments}
\alias{Fragments}
\alias{Fragments<-}
\alias{Fragments.ChromatinAssay}
\alias{Fragments.Seurat}
\alias{Fragments<-.ChromatinAssay}
\alias{Fragments<-.Seurat}
\title{Get the Fragment objects}
\usage{
Fragments(object, ...)

Fragments(object, ...) <- value

\method{Fragments}{ChromatinAssay}(object, ...)

\method{Fragments}{Seurat}(object, ...)

\method{Fragments}{ChromatinAssay}(object, ...) <- value

\method{Fragments}{Seurat}(object, ...) <- value
}
\arguments{
\item{object}{A Seurat object or ChromatinAssay object}

\item{...}{Arguments passed to other methods}

\item{value}{A \code{\link{Fragment}} object or list of Fragment objects}
}
\value{
Returns a list of \code{\link{Fragment}} objects. If there are
no Fragment objects present, returns an empty list.
}
\description{
Get the Fragment objects
}
\examples{
Fragments(atac_small[["peaks"]])
Fragments(atac_small)
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
fragments <- CreateFragmentObject(
  path = fpath,
  cells = colnames(atac_small),
  validate.fragments = FALSE
)
Fragments(atac_small[["bins"]]) <- fragments
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
fragments <- CreateFragmentObject(
  path = fpath,
  cells = colnames(atac_small),
  validate.fragments = FALSE
)
Fragments(atac_small) <- fragments
}
\concept{assay}
\concept{fragments}
