% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_aft.R
\name{analyse_aft}
\alias{analyse_aft}
\title{Analyse Dataset with accelarated failure time models}
\usage{
analyse_aft(level = 0.95, dist = "weibull", alternative = "two.sided")
}
\arguments{
\item{level}{confidence level for CI computation}

\item{dist}{passed to survival::survreg}

\item{alternative}{alternative hypothesis for the tests "two.sided" or "one.sieded"}
}
\value{
an analyse function that returns a list with the elements
\itemize{
\item \code{p} p value of the score test (two.sided) or the Wald test (one.sided)
\item \code{alternative} the alternative used
\item \code{coef} coefficient for \code{trt}
\item \code{lower} lower 95\% confidence intervall boundary for the coefficient
\item \code{upper}lower 95\% confidence intervall boundary for the coefficient
\item \code{CI_level} the CI level used
\item \code{N_pat} number of patients
\item \code{N_evt} number of events
}
}
\description{
Analyse Dataset with accelarated failure time models
}
\details{
\code{alternative} can be "two.sided" for a two sided test of equality of the
summary statistic or "one.sided" for a one sided test testing H0: treatment
has equal or shorter survival than control vs. H1 treatment has longer
survival than control.
}
\examples{
condition <- merge(
  assumptions_delayed_effect(),
  design_fixed_followup(),
  by = NULL
) |>
  head(1)
dat <- generate_delayed_effect(condition)
analyse_aft()(condition, dat)
analyse_aft(dist="lognormal")(condition, dat)
}
