% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{KoreanSocialSurvey_tbl_df}
\alias{KoreanSocialSurvey_tbl_df}
\title{A Sample of Korean General Social Survey Data, 2023}
\format{
A tibble with 1123 observations and 13 variables:
\describe{
  \item{year}{Survey year (numeric)}
  \item{respid}{Respondent identifier (numeric)}
  \item{age}{Age of the respondent (numeric)}
  \item{female}{Gender indicator: 1 = female, 0 = male (numeric)}
  \item{employed}{Employment status indicator (numeric)}
  \item{unived}{University education indicator (numeric)}
  \item{netuse}{Internet use indicator (numeric)}
  \item{ideo}{Political ideology score (numeric)}
  \item{si_gbh}{Regional code or classification (numeric)}
  \item{satisfin}{Satisfaction with financial situation (numeric)}
  \item{fp_mord}{Attitude toward moral issues (numeric)}
  \item{fpcat}{Category for family planning or related topics (character)}
  \item{cntryaffq}{Country affiliation or related attitude (character)}
}
}
\source{
Data taken from the \pkg{simqi} package version 0.2.0
}
\usage{
data(KoreanSocialSurvey_tbl_df)
}
\description{
This dataset, KoreanSocialSurvey_tbl_df, is a tibble containing a sample of data
from the Korean General Social Survey (KGSS) conducted in 2023. It includes
demographic, social, and attitudinal variables for respondents.
}
\details{
The dataset name has been kept as 'KoreanSocialSurvey_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
SouthKoreAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
