% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{Csweep}
\alias{Csweep}
\title{Calling C-implementation of the SWEEP-Operator}
\usage{
Csweep(M, asgn, thresh = 1e-12, tol = 1e-12, Ncpu = 1)
}
\arguments{
\item{M}{(matrix) matrix, representing the augmented matrix \eqn{X'X}}

\item{asgn}{(integer) vector, identifying columns in \eqn{M} corresponding to variables, 
respectively, to their coefficients}

\item{thresh}{(numeric) value used to check whether the influence of the a coefficient
to reducing the error sum of squares is small enough to conclude that the
corresponding column in \eqn{X'X} is a linear combination of preceding 
columns}

\item{tol}{(numeric) value used to check numerical equivalence to zero}

\item{Ncpu}{(integer) number of cores to be used for parallel processing
(not yet used)}
}
\value{
(list) with two elements:\cr
			\item{SSQ}{(numeric) vector of ANOVA sum of squares}
			\item{LC}{(integer) vector indicating linear dependence of each column}
}
\description{
Function calls a fast C-implementation of the SWEEP operator using the
transpose of the original augmented matrix \eqn{X'X} (see \code{\link{getSSQsweep}}).
}
\details{
Transposing prior to applying the SWEEP-operator speeds up things since the 
complete matrix is stored in memory in consecutive manner.

This is an utility-function not intended to be called directly.
}
\examples{
\dontrun{
# use example from 'lm' Rdoc
ctl    <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt    <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group  <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9  <- lm(weight ~ group)
anova(lm.D9)

# create augmented matrix
X  <- model.matrix(lm.D9)
Xt <- t(X)
y  <- matrix(weight, ncol=1)
yt <- t(y)
M  <- rbind(	cbind(as.matrix(Xt\%*\%X), as.matrix(Xt\%*\%y)), 
		        cbind(as.matrix(yt\%*\%X), as.matrix(yt\%*\%y)))
swept <- VCA:::Csweep(M, asgn=c(0,1))					
LC    <- swept$LC
SS    <- swept$SSQ
SSQ   <- abs(diff(SS))
SSQ   <- c(SSQ, tail(SS,1))
SSQ		# compare to column "Sum Sq" in 'anova(lmD9)' output
}
}
\references{
Goodnight, J.H. (1979), A Tutorial on the SWEEP Operator, The American Statistician, 33:3, 149-158
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
