% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_time_series.R
\name{to_time_series}
\alias{to_time_series}
\title{Create a tibble-like \code{tsd} (time-series data) object from observed data and corresponding dates.}
\usage{
to_time_series(observation, time, time_interval = c("day", "week", "month"))
}
\arguments{
\item{observation}{A numeric vector containing the observations.}

\item{time}{A date vector containing the corresponding dates.}

\item{time_interval}{A character vector specifying the time interval. Choose between 'day', 'week', or 'month'.}
}
\value{
A \code{tsd} object containing:
\itemize{
\item 'time': The time point for for when the observation is observed.
\item 'observation': The observed value at the time point.
}
}
\description{
This function takes observations and the corresponding date vector and converts it into a \code{tsd} object, which is
a time series data structure that can be used for time series analysis.
}
\examples{
# Create a `tsd` object from daily data
daily_tsd <- to_time_series(
  observation = c(10, 15, 20, 18),
  time = as.Date(
    c("2023-01-01", "2023-01-02", "2023-01-03", "2023-01-04")
  ),
  time_interval = "day"
)

# Create a `tsd` object from weekly data
weekly_tsd <- to_time_series(
  observation = c(100, 120, 130),
  time = as.Date(
    c("2023-01-01", "2023-01-08", "2023-01-15")
  ),
  time_interval = "week"
)

# Create a `tsd` object from monthly data
monthly_tsd <- to_time_series(
  observation = c(500, 520, 540),
  time = as.Date(
    c("2023-01-01", "2023-02-01", "2023-03-01")
  ),
  time_interval = "month"
)

}
