% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{gwet_ac}
\alias{gwet_ac}
\title{Calculate Gwet's AC1 and AC2}
\usage{
gwet_ac(rater_one, rater_two, additional_raters = NULL)
}
\arguments{
\item{rater_one}{\code{factor} rating of the first coder.}

\item{rater_two}{\code{factor} ratings of the second coder.}

\item{additional_raters}{\code{list} Additional raters with same requirements as \code{rater_one} and \code{rater_two}. If
there are no additional raters set to \code{NULL}.}
}
\value{
Returns a \code{list} with the following entries
\itemize{
\item ac1: Gwet's Agreement Coefficient 1 (AC1) for nominal data which is unweighted.
\item ac2_linear: Gwet's Agreement Coefficient 2 (AC2) for ordinal data with linear weights.
\item ac2_quadratic: Gwet's Agreement Coefficient 2 (AC2) for ordinal data with quadratic weights.
}
}
\description{
This function calculates Gwets Agreement Coefficients.
}
\note{
Weights are calculated as described in Gwet (2021).

Missing values are supported.
}
\references{
Gwet, K. L. (2021). Handbook of inter-rater reliability:
The definitive guide to measuring the extent of agreement among raters
(Fifth edition, volume 1). AgreeStat Analytics.
}
\seealso{
Other performance measures: 
\code{\link{calc_standard_classification_measures}()},
\code{\link{cohens_kappa}()},
\code{\link{fleiss_kappa}()},
\code{\link{get_coder_metrics}()},
\code{\link{kendalls_w}()},
\code{\link{kripp_alpha}()}
}
\concept{performance measures}
