% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzTransitionProbabilities.R,
%   R/mostLikelyHzSequence.R
\name{hzTransitionProbabilities}
\alias{hzTransitionProbabilities}
\alias{mostLikelyHzSequence}
\title{Horizon Transition Probabilities}
\usage{
hzTransitionProbabilities(
  x,
  name = GHL(x, required = TRUE),
  loopTerminalStates = FALSE
)

mostLikelyHzSequence(mc, t0, maxIterations = 10)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object.}

\item{name}{A horizon level attribute in \code{x} that names horizons.}

\item{loopTerminalStates}{should terminal states loop back to themselves?

This is useful when the transition probability matrix will be used to
initialize a \code{markovchain} object. See examples below.}

\item{mc}{Passed to \code{markovchain} \code{conditionalDistribution()}}

\item{t0}{Passed to \code{markovchain} \code{conditionalDistribution()}}

\item{maxIterations}{Maximum number of iterations. Default: \code{10}}
}
\value{
A square matrix of transition probabilities. See examples.

The function \code{\link[=genhzTableToAdjMat]{genhzTableToAdjMat()}} returns a square adjacency matrix.
See examples.

The function \code{\link[=mostLikelyHzSequence]{mostLikelyHzSequence()}} returns the most likely sequence of
horizons, given a \code{markovchain} object initialized from horizon
transition probabilities and an initial state, \code{t0}. See examples.
}
\description{
Functions for creating and working with horizon (sequence) transition
probability matrices.

See the following tutorials for some ideas:
\itemize{
\item \href{http://ncss-tech.github.io/AQP/aqp/hz-transition-probabilities.html}{horizon designation TP}
\item \href{http://ncss-tech.github.io/AQP/aqp/series-color-TP-graph.html}{soil color TP}
}
}
\note{
These functions are still experimental and subject to change.
}
\examples{

data(sp4)
depths(sp4) <- id ~ top + bottom

# horizon transition probabilities: row -> col transitions
(tp <- hzTransitionProbabilities(sp4, 'name'))



}
\seealso{
\code{\link[=generalize.hz]{generalize.hz()}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
