% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check-numeric}
\alias{check-numeric}
\alias{assert_numeric}
\alias{assert_trend}
\alias{assert_relation}
\title{Check Numeric Values}
\usage{
assert_numeric(x, expected, ...)

assert_trend(x, expected, ...)

assert_relation(x, y, expected, ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} object to be checked.}

\item{expected}{A \code{\link{character}} string specifying the expected
value (see details).}

\item{...}{Extra parameters to be passed to internal methods.}
}
\value{
Throws an error, if any, and returns \code{x} invisibly otherwise.
}
\description{
Check Numeric Values
}
\details{
Possible values for \code{expected}:
\describe{
\item{\code{assert_numeric()}}{"\code{positive}", "\code{whole}", "\code{odd}" or "\code{even}"}
\item{\code{assert_trend()}}{"\code{constant}", "\code{decreasing}" or "\code{increasing}"}
\item{\code{assert_relation()}}{"\code{lower}" or "\code{greater}"}
}
}
\seealso{
Other validation methods: 
\code{\link{check-attribute}},
\code{\link{check-data}},
\code{\link{check-graph}},
\code{\link{check-matrix}},
\code{\link{check-type}},
\code{\link{validate}()}
}
\author{
N. Frerebeau
}
\concept{validation methods}
