% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/detect.R
\docType{methods}
\name{count}
\alias{count}
\alias{count-method}
\alias{count,matrix,function-method}
\alias{count,data.frame,function-method}
\title{Count values according to a given predicate}
\usage{
count(x, f, ...)

\S4method{count}{matrix,`function`}(x, f, margin = 1, negate = FALSE)

\S4method{count}{data.frame,`function`}(x, f, margin = 1, negate = FALSE)
}
\arguments{
\item{x}{An object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{f}{A predicate \code{\link{function}}.}

\item{...}{Currently not used.}

\item{margin}{A vector giving the subscripts which the function will be
applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{negate}{A \code{\link{logical}} scalar: should the negation of \code{f} be used
instead of \code{f}?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Counts values by rows/columns according to a given predicate.
}
\examples{
## Create a count data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Count missing values in rows
count(X, f = is.na, margin = 1)
## Count non-missing values in columns
count(X, f = is.na, margin = 2, negate = TRUE)

## Find row with NA
detect(X, f = is.na, margin = 1)
## Find column without any NA
detect(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Remove row with any NA
compact(X, f = is.na, margin = 1, all = FALSE)
## Remove column with any NA
compact(X, f = is.na, margin = 2, all = FALSE)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{assign}()},
\code{\link{detect}()},
\code{\link{remove}()},
\code{\link{replace}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
