% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{check-data}
\alias{check-data}
\alias{assert_missing}
\alias{assert_infinite}
\alias{assert_unique}
\title{Check Data}
\usage{
assert_missing(x)

assert_infinite(x)

assert_unique(x, expected)
}
\arguments{
\item{x}{An object to be checked.}

\item{expected}{An appropriate expected value.}
}
\value{
Throws an error, if any, and returns \code{x} invisibly otherwise.
}
\description{
\itemize{
\item \code{assert_missing()} and \code{assert_infinite()} check if an object contains any
missing (\code{NA}, \code{NaN}) or infinite (\code{Inf}) value.
\item \code{assert_unique()} checks if an object contains duplicated elements.
}
}
\seealso{
Other validation methods: 
\code{\link{check-attribute}},
\code{\link{check-matrix}},
\code{\link{check-numeric-comparison}},
\code{\link{check-numeric-trend}},
\code{\link{check-numeric}},
\code{\link{check-type}},
\code{\link{validate}()}
}
\author{
N. Frerebeau
}
\concept{validation methods}
