/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JTextArea;

public class AprioriTFP_CMAR
extends AprioriTFP_CARgen {
    protected static int MIN_COVER = 3;
    protected static final double THRESHOLD_10 = 2.7055;
    protected static final double THRESHOLD_5 = 3.8415;
    protected static final double THRESHOLD_2HALF = 5.0239;
    protected static final double THRESHOLD_1 = 6.6349;
    protected static final double THRESHOLD_HALF = 7.8794;
    protected RuleNodeCMAR startCMARrulelist = null;
    private double[] obsValues = new double[4];
    private double[] expValues = new double[4];
    private double supAntecedent;
    private double supNotAntecedent;
    private double supConsequent;
    private double supNotConsequent;
    private double supRule;
    private double numRecords;
    protected double threshold = 3.8415;

    public AprioriTFP_CMAR(String[] stringArray) {
        super(stringArray);
    }

    public AprioriTFP_CMAR(AssocRuleMining assocRuleMining) {
        super(assocRuleMining);
    }

    @Override
    public void startClassification() {
        String string = "START APRIORI-TFP CMAR\n------------------------------\nMin. rules to cover  = " + MIN_COVER + "\nCrit. threshold val. = " + this.threshold + "\nMax number of CARS   = " + 80000 + "\nMax size antecedent  = " + 6 + "\n";
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string);
        }
        this.startClassification2();
    }

    @Override
    public void startClassification(JTextArea jTextArea) {
        this.textArea = jTextArea;
        this.startClassification();
    }

    protected void startClassification2() {
        this.startCMARrulelist = null;
        this.startCARgeneration2();
        this.pruneUsingCover(this.copyItemSet(this.dataArray));
        if (this.ruleListAttNumOutputFlag || this.ruleListSchemaOutputFlag) {
            this.outputCMARrules();
        }
        this.testClassification();
    }

    @Override
    public void commenceTCVwithOutput() {
        double[][] dArray = new double[10][5];
        String string = "START TCV APRIORI-TFP CMAR CLASSIFICATION\n------------------------------\nMin. rules to cover  = " + MIN_COVER + "\nMax number of CARS   = " + 80000 + "\nMax size antecedent  = " + 6 + "\n";
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string);
        }
        for (int i = 0; i < 10; ++i) {
            string = "[--- " + (i + 1) + " ---] ";
            if (this.textArea == null) {
                System.out.println(string);
            } else {
                this.textArea.append(string);
            }
            this.createTrainingAndTestDataSets(i);
            this.startClassification();
            dArray[i][0] = this.accuracy;
            dArray[i][1] = this.aucValue;
            dArray[i][2] = this.numFrequentSets;
            dArray[i][3] = this.numUpdates;
            dArray[i][4] = this.getNumCMAR_CRs();
        }
        this.tcvOutput(dArray);
    }

    @Override
    public void commenceTCVwithOutput(JTextArea jTextArea) {
        this.textArea = jTextArea;
        this.commenceTCVwithOutput();
    }

    @Override
    protected void generateCARsRightLevel(short[] sArray, int n, short[] sArray2, TtreeNode[] ttreeNodeArray) {
        for (int i = 1; i < n; ++i) {
            short[] sArray3;
            double d;
            double d2;
            if (ttreeNodeArray[i] == null || !((d2 = this.getConfidence(d = (double)this.getSupportForItemSetInTtree(sArray3 = this.realloc2(sArray, (short)i)), (double)ttreeNodeArray[i].support)) >= this.confidence)) continue;
            ++this.numCarsSoFar;
            double d3 = this.getSupportForItemSetInTtree(sArray2);
            this.insertRinRlistCMARranking(sArray3, sArray2, d, d3, ttreeNodeArray[i].support, d2);
        }
    }

    protected void insertRinRlistCMARranking(short[] sArray, short[] sArray2, double d, double d2, double d3, double d4) {
        if (!this.testRuleUsingChiSquaredTesting(d, d2, d3, this.numRows)) {
            return;
        }
        RuleNodeCMAR ruleNodeCMAR = new RuleNodeCMAR(sArray, sArray2, d3, d, d2, d4);
        if (this.startCMARrulelist == null) {
            this.startCMARrulelist = ruleNodeCMAR;
            return;
        }
        if (this.moreGeneralRuleExists(ruleNodeCMAR)) {
            return;
        }
        if (this.ruleIsCMARgreater(ruleNodeCMAR, this.startCMARrulelist)) {
            ruleNodeCMAR.next = this.startCMARrulelist;
            this.startCMARrulelist = ruleNodeCMAR;
            return;
        }
        RuleNodeCMAR ruleNodeCMAR2 = this.startCMARrulelist;
        RuleNodeCMAR ruleNodeCMAR3 = this.startCMARrulelist.next;
        while (ruleNodeCMAR3 != null) {
            if (this.ruleIsCMARgreater(ruleNodeCMAR, ruleNodeCMAR3)) {
                ruleNodeCMAR2.next = ruleNodeCMAR;
                ruleNodeCMAR.next = ruleNodeCMAR3;
                return;
            }
            ruleNodeCMAR2 = ruleNodeCMAR3;
            ruleNodeCMAR3 = ruleNodeCMAR3.next;
        }
        ruleNodeCMAR2.next = ruleNodeCMAR;
    }

    private boolean moreGeneralRuleExists(RuleNodeCMAR ruleNodeCMAR) {
        RuleNodeCMAR ruleNodeCMAR2 = this.startCMARrulelist;
        while (ruleNodeCMAR2 != null) {
            if (this.ruleIsMoreGeneral(ruleNodeCMAR, ruleNodeCMAR2) && this.ruleIsCMARgreater2(ruleNodeCMAR, ruleNodeCMAR2)) {
                return true;
            }
            ruleNodeCMAR2 = ruleNodeCMAR2.next;
        }
        return false;
    }

    private boolean ruleIsMoreGeneral(RuleNodeCMAR ruleNodeCMAR, RuleNodeCMAR ruleNodeCMAR2) {
        return ruleNodeCMAR.antecedent.length < ruleNodeCMAR2.antecedent.length;
    }

    private boolean ruleIsCMARgreater(RuleNodeCMAR ruleNodeCMAR, RuleNodeCMAR ruleNodeCMAR2) {
        if (ruleNodeCMAR.confidenceForRule > ruleNodeCMAR2.confidenceForRule) {
            return true;
        }
        if (this.similar2dec(ruleNodeCMAR.confidenceForRule, ruleNodeCMAR2.confidenceForRule)) {
            if (ruleNodeCMAR.supportForRule > ruleNodeCMAR2.supportForRule) {
                return true;
            }
            if (this.similar2dec(ruleNodeCMAR.supportForRule, ruleNodeCMAR2.supportForRule) && ruleNodeCMAR.antecedent.length < ruleNodeCMAR2.antecedent.length) {
                return true;
            }
        }
        return false;
    }

    private boolean ruleIsCMARgreater2(RuleNodeCMAR ruleNodeCMAR, RuleNodeCMAR ruleNodeCMAR2) {
        if (ruleNodeCMAR.confidenceForRule > ruleNodeCMAR2.confidenceForRule) {
            return true;
        }
        return this.similar2dec(ruleNodeCMAR.confidenceForRule, ruleNodeCMAR2.confidenceForRule) && ruleNodeCMAR.supportForRule > ruleNodeCMAR2.supportForRule;
    }

    public boolean testRuleUsingChiSquaredTesting(double d, double d2, double d3, double d4) {
        double d5 = this.getChiSquaredValue(d, d2, d3, d4);
        return d5 > this.threshold;
    }

    private double getChiSquaredValue(double d, double d2, double d3, double d4) {
        this.supAntecedent = d;
        this.supConsequent = d2;
        this.supRule = d3;
        this.numRecords = d4;
        this.calculateObsValues();
        this.calculateExpValues();
        return this.calcChiSquaredValue();
    }

    private void calculateObsValues() {
        this.obsValues[0] = this.supRule;
        this.obsValues[1] = this.supAntecedent - this.supRule;
        this.obsValues[2] = this.supConsequent - this.supRule;
        this.obsValues[3] = this.numRecords - this.supAntecedent - this.supConsequent + this.supRule;
        this.supNotAntecedent = this.numRecords - this.supAntecedent;
        this.supNotConsequent = this.numRecords - this.supConsequent;
    }

    private void calculateExpValues() {
        this.expValues[0] = this.supConsequent * this.supAntecedent / this.numRecords;
        this.expValues[1] = this.supNotConsequent * this.supAntecedent / this.numRecords;
        this.expValues[2] = this.supConsequent * this.supNotAntecedent / this.numRecords;
        this.expValues[3] = this.supNotConsequent * this.supNotAntecedent / this.numRecords;
    }

    private double calcChiSquaredValue() {
        double d = 0.0;
        for (int i = 0; i < this.obsValues.length; ++i) {
            double d2 = Math.pow(this.obsValues[i] - this.expValues[i], 2.0) / this.expValues[i];
            d += d2;
        }
        return d;
    }

    protected void pruneUsingCover(short[][] sArray) {
        int[] nArray = new int[sArray.length];
        RuleNodeCMAR ruleNodeCMAR = null;
        RuleNodeCMAR ruleNodeCMAR2 = null;
        RuleNodeCMAR ruleNodeCMAR3 = this.startCMARrulelist;
        while (ruleNodeCMAR3 != null && !this.emptyDataSet(sArray)) {
            int n;
            boolean bl = false;
            for (n = 0; n < sArray.length; ++n) {
                if (!this.isSubset(ruleNodeCMAR3.antecedent, sArray[n])) continue;
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
                bl = true;
            }
            if (bl) {
                if (ruleNodeCMAR == null) {
                    ruleNodeCMAR = ruleNodeCMAR3;
                } else {
                    ruleNodeCMAR2.next = ruleNodeCMAR3;
                }
                ruleNodeCMAR2 = ruleNodeCMAR3;
                ruleNodeCMAR3 = ruleNodeCMAR3.next;
                ruleNodeCMAR2.next = null;
            } else {
                ruleNodeCMAR3 = ruleNodeCMAR3.next;
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] <= MIN_COVER) continue;
                sArray[n] = null;
            }
        }
        this.startCMARrulelist = ruleNodeCMAR;
    }

    private boolean emptyDataSet(short[][] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void testClassification() {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.canTestingBeUndertaken()) {
            this.accuracy = 0.0;
            this.aucValue = 0.0;
            return;
        }
        int[][] nArray = new int[this.testDataArray.length][this.numClasses];
        int[][] nArray2 = new int[this.testDataArray.length][this.numClasses];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            for (n3 = 0; n3 < nArray[n4].length; ++n3) {
                nArray[n4][n3] = 0;
            }
        }
        for (n4 = 0; n4 < nArray2.length; ++n4) {
            for (n3 = 0; n3 < nArray2[n4].length; ++n3) {
                nArray2[n4][n3] = 0;
            }
        }
        n4 = 0;
        n3 = 0;
        int n5 = 0;
        int n6 = this.numOneItemSets - this.numClasses + 1;
        for (n2 = 0; n2 < this.testDataArray.length; ++n2) {
            short s = this.classifyRecordWCS(this.testDataArray[n2]);
            if (s == 0) {
                ++n5;
                continue;
            }
            short s2 = this.getLastElement(this.testDataArray[n2]);
            n = s2 - n6;
            nArray[n2][n] = 1;
            n = s - n6;
            nArray2[n2][n] = 1;
            if (s == s2) {
                ++n4;
                continue;
            }
            ++n3;
        }
        this.accuracy = (double)n4 * 100.0 / (double)n2;
        double d = 0.0;
        for (n = 0; n < this.numClasses - 1; ++n) {
            for (int i = n + 1; i < this.numClasses; ++i) {
                double d2 = this.calcMWWstatValue(n, i, nArray2, nArray);
                double d3 = this.calcMWWstatValue(i, n, nArray2, nArray);
                double d4 = (d2 + d3) / 2.0;
                d += d4;
            }
        }
        this.aucValue = 2.0 / ((double)this.numClasses * ((double)this.numClasses - 1.0)) * d;
    }

    private boolean canTestingBeUndertaken() {
        if (this.testDataArray == null) {
            String string = "WARNING: No test data\n";
            if (this.textArea == null) {
                System.out.print(string);
            } else {
                this.textArea.append(string);
            }
            return false;
        }
        if (this.startCMARrulelist == null) {
            String string = "No CMAR classification rules generated!\n";
            if (this.textArea == null) {
                System.out.print(string);
            } else {
                this.textArea.append(string);
            }
            return false;
        }
        return true;
    }

    protected short classifyRecordWCS(short[] sArray) {
        RuleNodeCMAR ruleNodeCMAR = this.startCMARrulelist;
        RuleNodeCMAR ruleNodeCMAR2 = this.startCMARrulelist;
        this.startCMARrulelist = null;
        this.obtainallRulesForRecord(ruleNodeCMAR, sArray);
        if (this.startCMARrulelist == null) {
            this.startCMARrulelist = ruleNodeCMAR2;
            return 0;
        }
        if (this.startCMARrulelist.next == null) {
            short s = this.startCMARrulelist.consequent[0];
            this.startCMARrulelist = ruleNodeCMAR2;
            return s;
        }
        if (this.onlyOneClass()) {
            short s = this.startCMARrulelist.consequent[0];
            this.startCMARrulelist = ruleNodeCMAR2;
            return s;
        }
        RuleNodeCMAR[] ruleNodeCMARArray = this.groupRules();
        double[] dArray = this.calcWCSvalues(ruleNodeCMARArray);
        short s = this.selectBestWCS(dArray);
        this.startCMARrulelist = ruleNodeCMAR2;
        return s;
    }

    private RuleNodeCMAR[] groupRules() {
        RuleNodeCMAR[] ruleNodeCMARArray = new RuleNodeCMAR[this.numClasses];
        for (int i = 0; i < ruleNodeCMARArray.length; ++i) {
            ruleNodeCMARArray[i] = null;
        }
        RuleNodeCMAR ruleNodeCMAR = this.startCMARrulelist;
        while (ruleNodeCMAR != null) {
            int n = this.numOneItemSets - ruleNodeCMAR.consequent[0];
            RuleNodeCMAR ruleNodeCMAR2 = new RuleNodeCMAR(ruleNodeCMAR.antecedent, ruleNodeCMAR.consequent, ruleNodeCMAR.supportForRule, ruleNodeCMAR.suppAntecedent, ruleNodeCMAR.suppConsequent, ruleNodeCMAR.confidenceForRule);
            ruleNodeCMAR2.next = ruleNodeCMARArray[n];
            ruleNodeCMARArray[n] = ruleNodeCMAR2;
            ruleNodeCMAR = ruleNodeCMAR.next;
        }
        return ruleNodeCMARArray;
    }

    private boolean onlyOneClass() {
        RuleNodeCMAR ruleNodeCMAR = this.startCMARrulelist;
        short s = ruleNodeCMAR.consequent[0];
        ruleNodeCMAR = ruleNodeCMAR.next;
        while (ruleNodeCMAR != null) {
            if (ruleNodeCMAR.consequent[0] != s) {
                return false;
            }
            ruleNodeCMAR = ruleNodeCMAR.next;
        }
        return true;
    }

    private double[] calcWCSvalues(RuleNodeCMAR[] ruleNodeCMARArray) {
        double[] dArray = new double[ruleNodeCMARArray.length];
        for (int i = 0; i < ruleNodeCMARArray.length; ++i) {
            RuleNodeCMAR ruleNodeCMAR = ruleNodeCMARArray[i];
            double d = 0.0;
            while (ruleNodeCMAR != null) {
                double d2 = this.getChiSquaredValue(ruleNodeCMAR.suppAntecedent, ruleNodeCMAR.suppConsequent, ruleNodeCMAR.supportForRule, this.numRecords);
                double d3 = this.calcChiSquaredUpperBound(ruleNodeCMAR.suppAntecedent, ruleNodeCMAR.suppConsequent);
                d += d2 * d2 / d3;
                ruleNodeCMAR = ruleNodeCMAR.next;
            }
            dArray[i] = d;
        }
        return dArray;
    }

    private short selectBestWCS(double[] dArray) {
        double d = dArray[0];
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
            n = i;
        }
        return (short)(this.numOneItemSets - n);
    }

    private double calcChiSquaredUpperBound(double d, double d2) {
        double d3 = d < d2 ? Math.pow(d - d * d2 / this.numRecords, 2.0) : Math.pow(d2 - d * d2 / this.numRecords, 2.0);
        double d4 = this.calcWCSeValue(d, d2);
        return d3 * d4 * this.numRecords;
    }

    private double calcWCSeValue(double d, double d2) {
        double d3 = 1.0 / (d * d2);
        double d4 = 1.0 / (d * (this.numRecords - d2));
        double d5 = 1.0 / (d2 * (this.numRecords - d));
        double d6 = 1.0 / ((this.numRecords - d) * (this.numRecords - d2));
        return d3 + d4 + d5 + d6;
    }

    private void obtainallRulesForRecord(RuleNodeCMAR ruleNodeCMAR, short[] sArray) {
        RuleNodeCMAR ruleNodeCMAR2 = null;
        RuleNodeCMAR ruleNodeCMAR3 = null;
        while (ruleNodeCMAR != null) {
            if (this.isSubset(ruleNodeCMAR.antecedent, sArray)) {
                RuleNodeCMAR ruleNodeCMAR4 = new RuleNodeCMAR(ruleNodeCMAR.antecedent, ruleNodeCMAR.consequent, ruleNodeCMAR.supportForRule, ruleNodeCMAR.suppAntecedent, ruleNodeCMAR.suppConsequent, ruleNodeCMAR.confidenceForRule);
                if (ruleNodeCMAR2 == null) {
                    ruleNodeCMAR2 = ruleNodeCMAR4;
                } else {
                    ruleNodeCMAR3.next = ruleNodeCMAR4;
                }
                ruleNodeCMAR3 = ruleNodeCMAR4;
            }
            ruleNodeCMAR = ruleNodeCMAR.next;
        }
        this.startCMARrulelist = ruleNodeCMAR2;
    }

    public int getNumCMAR_CRs() {
        int n = 0;
        RuleNodeCMAR ruleNodeCMAR = this.startCMARrulelist;
        while (ruleNodeCMAR != null) {
            ++n;
            ruleNodeCMAR = ruleNodeCMAR.next;
        }
        return n;
    }

    public void setChiSquaredTestingParams(double d) {
        int n = (int)(d * 100.0);
        switch (n) {
            case 1000: {
                this.threshold = 2.7055;
                break;
            }
            case 500: {
                this.threshold = 3.8415;
                break;
            }
            case 250: {
                this.threshold = 5.0239;
                break;
            }
            case 100: {
                this.threshold = 6.6349;
                break;
            }
            case 50: {
                this.threshold = 7.8794;
                break;
            }
            default: {
                System.out.println("No hard coded Chi squared critical threshold value for " + d + "%, selected value for 5% (default)");
            }
        }
    }

    public void outputCMARrules() {
        this.outputRules(this.startCMARrulelist);
    }

    public void outputRules(RuleNodeCMAR ruleNodeCMAR) {
        if (ruleNodeCMAR == null) {
            String string = "No rules generated!\n";
            if (this.textArea == null) {
                System.out.println(string);
            } else {
                this.textArea.append(string);
            }
            return;
        }
        String string = "(#) Ante -> Cons confidence % (Sup. Rule, Sup. Ante, Sup. Cons.)\n---------------------------------------------\n";
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string);
        }
        int n = 1;
        RuleNodeCMAR ruleNodeCMAR2 = ruleNodeCMAR;
        while (ruleNodeCMAR2 != null) {
            if (this.textArea == null) {
                this.outputRule(n, ruleNodeCMAR2);
            } else {
                this.outputRule(this.textArea, n, ruleNodeCMAR2);
            }
            ++n;
            ruleNodeCMAR2 = ruleNodeCMAR2.next;
        }
    }

    private void outputRule(int n, RuleNodeCMAR ruleNodeCMAR) {
        System.out.print("(" + n + ") ");
        if (this.ruleListSchemaOutputFlag) {
            this.outputItemSetSchema(ruleNodeCMAR.antecedent);
        } else {
            this.outputItemSet(ruleNodeCMAR.antecedent);
        }
        System.out.print(" -> ");
        if (this.ruleListSchemaOutputFlag) {
            this.outputItemSetSchema(ruleNodeCMAR.consequent);
        } else {
            this.outputItemSet(ruleNodeCMAR.consequent);
        }
        System.out.println(" " + this.twoDecPlaces(ruleNodeCMAR.confidenceForRule) + "%, (" + ruleNodeCMAR.supportForRule + ", " + ruleNodeCMAR.suppAntecedent + ", " + ruleNodeCMAR.suppConsequent + ")");
    }

    private void outputRule(JTextArea jTextArea, int n, RuleNodeCMAR ruleNodeCMAR) {
        jTextArea.append("(" + n + ") ");
        if (this.ruleListSchemaOutputFlag) {
            this.outputItemSetSchema(jTextArea, ruleNodeCMAR.antecedent);
        } else {
            this.outputItemSet(jTextArea, ruleNodeCMAR.antecedent);
        }
        jTextArea.append(" -> ");
        if (this.ruleListSchemaOutputFlag) {
            this.outputItemSetSchema(jTextArea, ruleNodeCMAR.consequent);
        } else {
            this.outputItemSet(jTextArea, ruleNodeCMAR.consequent);
        }
        String string = " " + this.twoDecPlaces(ruleNodeCMAR.confidenceForRule) + "%, (" + ruleNodeCMAR.supportForRule + ", " + ruleNodeCMAR.suppAntecedent + ", " + ruleNodeCMAR.suppConsequent + ")\n";
        jTextArea.append(string);
    }

    public void outputNumCMARrules() {
        System.out.println("Number of CMAR rules    = " + this.getNumCMAR_CRs());
    }

    private void outputChiSquaredTestingValues(double[] dArray) {
        System.out.println(this.twoDecPlaces(dArray[0]) + "\t| " + this.twoDecPlaces(dArray[1]) + "\t| " + this.twoDecPlaces(dArray[0] + dArray[1]));
        System.out.println(this.twoDecPlaces(dArray[2]) + "\t| " + this.twoDecPlaces(dArray[3]) + "\t| " + this.twoDecPlaces(dArray[2] + dArray[3]));
        System.out.println("----------------------------------------------");
        System.out.println(this.twoDecPlaces(dArray[0] + dArray[2]) + "\t| " + this.twoDecPlaces(dArray[1] + dArray[3]) + "\t| " + this.twoDecPlaces(dArray[0] + dArray[1] + dArray[2] + dArray[3]));
        System.out.println("\n");
    }

    private void outputChiSquaredValueCalc() {
        double d = 0.0;
        System.out.println("O\t E\t (O-E)\t (O-E)^2\t ((O-E)^2)/2");
        for (int i = 0; i < this.obsValues.length; ++i) {
            double d2 = this.obsValues[i] - this.expValues[i];
            System.out.print(this.twoDecPlaces(this.obsValues[i]) + "\t| " + this.twoDecPlaces(this.expValues[i]) + "\t| " + this.twoDecPlaces(d2) + "\t| " + this.twoDecPlaces(Math.pow(d2, 2.0)) + "\t| ");
            double d3 = Math.pow(d2, 2.0) / this.expValues[i];
            System.out.println(this.twoDecPlaces(d3));
            d += d3;
        }
        System.out.println("\n");
    }

    private void outputGroups(RuleNodeCMAR[] ruleNodeCMARArray) {
        for (int i = 0; i < ruleNodeCMARArray.length; ++i) {
            System.out.println("Group " + i);
            this.outputRules(ruleNodeCMARArray[i]);
            System.out.println();
        }
    }

    protected class RuleNodeCMAR {
        protected short[] antecedent;
        protected short[] consequent;
        double confidenceForRule = 0.0;
        double supportForRule = 0.0;
        double suppAntecedent = 0.0;
        double suppConsequent = 0.0;
        RuleNodeCMAR next = null;

        private RuleNodeCMAR(short[] sArray, short[] sArray2, double d, double d2, double d3, double d4) {
            this.antecedent = sArray;
            this.consequent = sArray2;
            this.supportForRule = d;
            this.suppAntecedent = d2;
            this.suppConsequent = d3;
            this.confidenceForRule = d4;
        }
    }
}

