% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_lambda.R
\name{adjust_lambda}
\alias{adjust_lambda}
\title{Adjust Lambda}
\usage{
adjust_lambda(design, ...)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{...}{Further arguments.}
}
\value{
A list containing the greatest estimated value for \code{lambda} with
\code{prec_digits} decimal places which controls the family wise error rate
at level \code{alpha} (one-sided) and the estimated family wise error rate
for the estimated \code{lambda}.
}
\description{
Adjust Lambda
}
\details{
The default method for \code{adjust_lambda} uses a combination
of \code{\link{uniroot}} and grid search and calls \code{\link{toer}}
in every iteration. For methods implemented in the \code{bhmbasket} package
there are separate methods that are computationally more efficient.
}
\examples{
design <- setup_cpp(k = 3, p0 = 0.2)
adjust_lambda(design = design, n = 20, alpha = 0.05,
  design_params = list(tune_a = 1, tune_b = 1), iter = 1000)
}
