% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_details.R
\name{get_details}
\alias{get_details}
\title{Get Details of a Basket Trial Simulation}
\usage{
get_details(design, ...)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{...}{Further arguments.}
}
\value{
A list containing the rejection probabilites, posterior means, mean
squared errors of all baskets and the family-wise error rate. For some
methods the mean limits of HDI intervals are also returned.
}
\description{
Get Details of a Basket Trial Simulation
}
\examples{
# Example for a basket trial with Fujikawa's Design
design <- setup_fujikawa(k = 3, p0 = 0.2)
get_details(design = design, n = 20, p1 = c(0.2, 0.5, 0.5), lambda = 0.95,
  epsilon = 2, tau = 0, iter = 100)
}
