% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerBatchNLoptr.R
\name{mlr_optimizers_nloptr}
\alias{mlr_optimizers_nloptr}
\alias{OptimizerBatchNLoptr}
\title{Non-linear Optimization}
\source{
Johnson, G S (2020).
\dQuote{The NLopt nonlinear-optimization package.}
\url{https://github.com/stevengj/nlopt}.
}
\description{
\code{OptimizerBatchNLoptr} class that implements non-linear optimization.
Calls \code{\link[nloptr:nloptr]{nloptr::nloptr()}} from package \CRANpkg{nloptr}.
}
\section{Parameters}{

\describe{
\item{\code{algorithm}}{\code{character(1)}\cr
Algorithm to use.
See \code{\link[nloptr:nloptr.print.options]{nloptr::nloptr.print.options()}} for available algorithms.}
\item{\code{x0}}{\code{numeric()}\cr
Initial parameter values.
Use \code{start_values} parameter to create \code{"random"} or \code{"center"} start values.}
\item{\code{start_values}}{\code{character(1)}\cr
Create \code{"random"} start values or based on \code{"center"} of search space?
In the latter case, it is the center of the parameters before a trafo is applied.
Custom start values can be passed via the \code{x0} parameter.}
\item{\code{approximate_eval_grad_f}}{\code{logical(1)}\cr
Should gradients be numerically approximated via finite differences (\link[nloptr:nl.grad]{nloptr::nl.grad}).
Only required for certain algorithms.
Note that function evaluations required for the numerical gradient approximation will be logged as usual and are not treated differently than regular function evaluations by, e.g., \link{Terminator}s.}
}

For the meaning of other control parameters, see \code{\link[nloptr:nloptr]{nloptr::nloptr()}} and \code{\link[nloptr:nloptr.print.options]{nloptr::nloptr.print.options()}}.
}

\section{Internal Termination Parameters}{

The algorithm can terminated with all \link{Terminator}s.
Additionally, the following internal termination parameters can be used:

\describe{
\item{\code{stopval}}{\code{numeric(1)}\cr
Stop value.
Deactivate with \code{-Inf}.
Default is \code{-Inf}.}
\item{\code{maxtime}}{\code{integer(1)}\cr
Maximum time.
Deactivate with \code{-1L}.
Default is \code{-1L}.}
\item{\code{maxeval}}{\code{integer(1)}\cr
Maximum number of evaluations.
Deactivate with \code{-1L}.
Default is \code{-1L}.}
\item{\code{xtol_rel}}{\code{numeric(1)}\cr
Relative tolerance.
Original default is 10^-4.
Deactivate with \code{-1}.
Overwritten with \code{-1}.}
\item{\code{xtol_abs}}{\code{numeric(1)}\cr
Absolute tolerance.
Deactivate with \code{-1}.
Default is \code{-1}.}
\item{\code{ftol_rel}}{\code{numeric(1)}\cr
Relative tolerance.
Deactivate with \code{-1}.
Default is \code{-1}.}
\item{\code{ftol_abs}}{\code{numeric(1)}\cr
Absolute tolerance.
Deactivate with \code{-1}.
Default is \code{-1}.}
}
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
\dontshow{if (requireNamespace("nloptr", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\dontshow{\}) # examplesIf}
\donttest{
  search_space = domain = ps(x = p_dbl(lower = -1, upper = 1))

  codomain = ps(y = p_dbl(tags = "minimize"))

  objective_function = function(xs) {
    list(y = as.numeric(xs)^2)
  }

  objective = ObjectiveRFun$new(
    fun = objective_function,
    domain = domain,
    codomain = codomain)


  # We use the internal termination criterion xtol_rel
  terminator = trm("none")
  instance = OptimInstanceBatchSingleCrit$new(
    objective = objective,
    search_space = search_space,
    terminator = terminator)


  optimizer = opt("nloptr", algorithm = "NLOPT_LN_BOBYQA")

  # Modifies the instance by reference
  optimizer$optimize(instance)

  # Returns best scoring evaluation
  instance$result

  # Allows access of data.table of full path of all evaluations
  as.data.table(instance$archive)
}

}
\section{Super classes}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{\link[bbotk:OptimizerBatch]{bbotk::OptimizerBatch}} -> \code{OptimizerBatchNLoptr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerBatchNLoptr-new}{\code{OptimizerBatchNLoptr$new()}}
\item \href{#method-OptimizerBatchNLoptr-clone}{\code{OptimizerBatchNLoptr$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimizerBatch" data-id="optimize"><a href='../../bbotk/html/OptimizerBatch.html#method-OptimizerBatch-optimize'><code>bbotk::OptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchNLoptr-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchNLoptr-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchNLoptr$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchNLoptr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchNLoptr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchNLoptr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
