% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bife.R
\name{bife_control}
\alias{bife_control}
\title{Set \code{bife} Control Parameters}
\usage{
bife_control(
  dev_tol = 1e-08,
  iter_max = 25L,
  trace = FALSE,
  rho_tol = NULL,
  conv_tol = NULL
)
}
\arguments{
\item{dev_tol}{tolerance level for the first stopping condition of the maximization routine. The 
stopping condition is based on the relative change of the deviance in iteration \eqn{r}
and can be expressed as follows: 
\eqn{|dev_{r} - dev_{r - 1}| / (0.1 + |dev_{r}|) < tol}{|dev - devold| / (0.1 + |dev|) < tol}.
Default is \code{1.0e-08}.}

\item{iter_max}{unsigned integer indicating the maximum number of iterations in the maximization
routine. Default is \code{25L}.}

\item{trace}{logical indicating if output should be produced in each iteration. Default is \code{FALSE}.}

\item{conv_tol, rho_tol}{deprecated; step-halving is now similar to \code{glm.fit2}.}
}
\value{
The function \code{\link{bife_control}} returns a named list of control 
parameters.
}
\description{
Set and change parameters used for fitting \code{\link{bife}}.
}
\seealso{
\code{\link{bife}}
}
