# Documentation

The Bio3D package for structural bioinformatics consists of sets of functions for:

- <a href="#Input/Output:">input/output</a>,
- <a href="#Sequence Analysis:">sequence analysis</a>, 
- <a href="#Structure Analysis:">structure analysis</a>,
- <a href="#Trajectory Analysis:">simulation analysis</a>,
- <a href="#Normal Mode Analysis:">normal mode analysis</a>, 
- <a href="#Correlation Network Analysis:"> correlation network analysis</a>,
- <a href="#Utilities:">format conversion and data manipulation</a>, and 
- <a href="#Graphics:">graphics and visualization.</a>. 
 
Major functions are listed below with links to further documentation that includes example code and results. 

Note that you can also get help on any particular function by using the command `?function` or `help(function)` (e.g. `help(read.pdb)`) and directly execute the example code for a given function with the command `example(function)` from within R itself. 

We also distribute a number of extended **Bio3D vignettes** that provide worked examples of using Bio3D to perform a particular type of analysis. Currently available vignettes include:

- [Installing Bio3D](http://thegrantlab.org/bio3d/articles/online/install_vignette/Bio3D_install.html)

- [Getting started with Bio3D](http://thegrantlab.org/bio3d/articles/online/intro_vignette/Bio3D_introduction.html)

- [PDB structure manipulation and analysis with Bio3D](http://thegrantlab.org/bio3d/articles/online/pdb_vignette/Bio3D_pdb.html)

- [Beginning trajectory analysis with Bio3D](http://thegrantlab.org/bio3d/articles/online/traj_vignette/Bio3D_md.html)

- [Enhanced methods for Normal Mode Analysis with Bio3D](http://thegrantlab.org/bio3d/articles/online/nma_vignette/Bio3D_nma.html)

- [Comparative sequence and structure analysis with Bio3D](http://thegrantlab.org/bio3d/articles/online/pca_vignette/Bio3D_pca.html)

- [Ensemble NMA of E.coli DHFR structures](http://thegrantlab.org/bio3d/articles/online/enma_vignettes/Bio3D_nma-dhfr-partI.html)

- [Ensemble NMA across multiple species of DHFR](http://thegrantlab.org/bio3d/articles/online/enma_vignettes/Bio3D_nma-dhfr-partII.html)

- [Protein structure network analysis with Bio3D](http://thegrantlab.org/bio3d/articles/online/cna_vignette/cna_vignette.spin.html)

- [Introduction to Ensemble Difference Distance Matrix (eDDM) Analysis](http://thegrantlab.org/bio3d/articles/online/eddm_vignette/Bio3D_eddm.spin.html)

- Online protein structure analysis with the Bio3D WebApp ( [PDF](http://thegrantlab.org/bio3d_v2/download/webapp-tutorials?download=22:bio3d-webapp-pca))

- Online Normal Mode Analysis with Bio3D WebApps ( PDF | HTML )

There is also extensive [on-line documentation](http://thegrantlab.org/bio3d/reference/) with worked examples (and their output) for all functions and a package manual (in [PDF](https://CRAN.R-project.org/package=bio3d/bio3d.pdf) format) that is a concatenation of each functions documentation (without example output). 

Note that for information on Bio3D development status or to report a bug, please refer to: https://bitbucket.org/Grantlab/bio3d 
