% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cNNTest.R
\name{cnnTest}
\alias{cnnTest}
\title{Permutation Test for cross-type nearest neighbor distances}
\usage{
cnnTest(
  dist,
  n1,
  n2,
  w = rep(1, n1 + n2),
  B = 999,
  alternative = "less",
  returnSample = TRUE,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{dist}{a distance matrix, the upper n1 x n1 part contains distances between objects of type 1
the lower n2 x n2 part contains distances between objects of type 2}

\item{n1}{numbers of objects of type 1}

\item{n2}{numbers of objects of type 2}

\item{w}{(optional) weights of the objects (length n1+n2)}

\item{B}{number of permutations to generate}

\item{alternative}{alternative hypothesis ("less" to test H0:Colocalization )}

\item{returnSample}{return sampled null distribution}

\item{parallel}{Logical. Should we use parallel computing?}

\item{...}{additional arguments for mclapply}
}
\value{
a list with the p.value, the observed weighted mean of the cNN-distances, alternative and (if returnSample) the simulated null dist
}
\description{
Permutation Test for cross-type nearest neighbor distances
}
\author{
Fabian Scheipl
}
