% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandr.display.r
\name{blandr.display}
\alias{blandr.display}
\title{Bland-Altman summary statistics display function}
\usage{
blandr.display(method1, method2, sig.level = 0.95)
}
\arguments{
\item{method1}{A list of numbers.}

\item{method2}{A list of numbers.}

\item{sig.level}{(Optional) Two-tailed significance level. Expressed from 0 to 1. Defaults to 0.95.}
}
\description{
Displays results of Bland-Altman analysis in a nicer text format. Relies on the blandr.statistics function in the package.
}
\examples{
# Generates two random measurements
measurement1 <- rnorm(100)
measurement2 <- rnorm(100)

# Displays basic statistics for the two measurements in a readable form
blandr.display( measurement1 , measurement2 )

}
\author{
Deepankar Datta <deepankardatta@nhs.net>
}
