% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{support_estimation}
\alias{support_estimation}
\title{support_estimation}
\usage{
support_estimation(beta_sample_q, gamma = 0.5)
}
\arguments{
\item{beta_sample_q}{a matrix. Each row is a coefficient function computed from the
posterior sample.}

\item{gamma}{a numeric value, the default value is \code{0.5}.}
}
\value{
a list containing:
\describe{
 \item{alpha}{a numerical vector. The approximated posterior probabilities
       that the coefficient function support covers \code{t} for each time
       points \code{t}.}
 \item{estimate}{a numerical vector, the support estimate.}
 \item{estimate_fct}{a numerical vector, another version of the support
       estimate.}
}
}
\description{
Compute the support estimate.
}
\examples{
data(data1)
data(param1)
# result of res_bliss1<-fit_Bliss(data=data1,param=param1)
data(res_bliss1)
res_support <- support_estimation(res_bliss1$beta_sample[[1]])

### The estimate
res_support$estimate
### Plot the result
grid <- res_bliss1$data$grids[[1]]
plot(grid,res_support$alpha,ylim=c(0,1),type="l",xlab="",ylab="")
for(k in 1:nrow(res_support$estimate)){
    segments(grid[res_support$estimate[k,1]],0.5,
             grid[res_support$estimate[k,2]],0.5,lwd=2,col=2)
    points(grid[res_support$estimate[k,1]],0.5,pch="|",lwd=2,col=2)
    points(grid[res_support$estimate[k,2]],0.5,pch="|",lwd=2,col=2)
}
abline(h=0.5,col=2,lty=2)
}
