% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board-class.R
\name{board_blocks}
\alias{board_blocks}
\alias{board_blocks<-}
\alias{board_block_ids}
\alias{rm_blocks}
\alias{board_links}
\alias{board_links<-}
\alias{board_link_ids}
\alias{modify_board_links}
\alias{board_stacks}
\alias{board_stacks<-}
\alias{board_stack_ids}
\alias{modify_board_stacks}
\alias{available_stack_blocks}
\title{Board utils}
\usage{
board_blocks(x)

board_blocks(x) <- value

board_block_ids(x)

rm_blocks(x, rm)

board_links(x)

board_links(x) <- value

board_link_ids(x)

modify_board_links(x, add = NULL, rm = NULL, mod = NULL)

board_stacks(x)

board_stacks(x) <- value

board_stack_ids(x)

modify_board_stacks(x, add = NULL, rm = NULL, mod = NULL)

available_stack_blocks(
  x,
  stacks = board_stacks(x),
  blocks = board_stack_ids(x)
)
}
\arguments{
\item{x}{Board}

\item{value}{Replacement value}

\item{rm}{Block/link/stack IDs to remove}

\item{add}{Links/stacks to add}

\item{mod}{Link/stacks to modify}

\item{blocks, stacks}{Sets of blocks/stacks}
}
\value{
Functions for retrieving, as well as updating components
(\code{board_blocks()}/\code{board_links()}/\code{board_stacks()} and
\verb{board_blocks<-()}/\verb{board_links<-()}/\verb{board_stacks<-()}) return corresponding
objects (i.e. \code{blocks}, \code{links} and \code{stacks}), while ID getters
(\code{board_block_ids()}, \code{board_link_ids()} and \code{board_stack_ids()}) return
character vectors, as does \code{available_stack_blocks()}. Convenience functions
\code{rm_blocks()}, \code{modify_board_links()} and \code{modify_board_stacks()} return an
updated \code{board} object.
}
\description{
A set of utility functions is available for querying and manipulating board
components (i.e. blocks, links and stacks). Functions for retrieving and
modifying board options are documented in \code{\link[=new_board_options]{new_board_options()}}.
}
\section{Blocks}{

Board blocks can be retrieved using \code{board_blocks()} and updated with the
corresponding replacement function \verb{board_blocks<-()}. If just the current
board IDs are of interest, \code{board_block_ids()} is available as short for
\code{names(board_blocks(x))}. In order to remove block(s) from a board, the
(generic) convenience function \code{rm_blocks()} is exported, which takes care
(in the default implementation for \code{board}) of also updating links and
stacks accordingly. The more basic replacement function \verb{board_blocks<-()}
might fail at validation of the updated board object if an inconsistent
state results from an update (e.g. a block referenced by a stack is no
longer available).
}

\section{Links}{

Board links can be retrieved using \code{board_links()} and updated with the
corresponding replacement function \verb{board_links<-()}. If only links IDs are
of interest, this is available as \code{board_link_ids()}, which is short for
\code{names(board_links(x))}. A (generic) convenience function for all kinds of
updates to board links in one is available as \code{modify_board_links()}. With
arguments \code{add}, \code{rm} and \code{mod}, links can be added, removed or modified in
one go.
}

\section{Stacks}{

Board stacks can be retrieved using \code{board_stacks()} and updated with the
corresponding replacement function \verb{board_stacks<-()}. If only the stack IDs
are of interest, this is available as \code{board_stack_ids()}, which is short
for \code{names(board_stacks(x))}. A (generic) convenience function to update
stacks is available as \code{modify_board_stacks()}, which can add, remove and
modify stacks depending on arguments passed as \code{add}, \code{rm} and \code{mod}. If
block IDs that are not already associated with a stack (i.e. "free" blocks)
are of interest, this is available as \code{available_stack_blocks()}.
}

\examples{
brd <- new_board(
  c(
     a = new_dataset_block(),
     b = new_subset_block()
  ),
  list(from = "a", to = "b")
)

board_blocks(brd)
board_block_ids(brd)

board_links(brd)
board_link_ids(brd)

board_stacks(brd)
board_stack_ids(brd)

}
