% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOLS.R
\name{orthogLS}
\alias{orthogLS}
\title{Mutually orthogonal latin square arrays of zize v}
\usage{
orthogLS(v)
}
\arguments{
\item{v}{the dimension of the required MOLS}
}
\value{
\item{Treatments}{A table showing the replication number of each treatment in the design.}
}
\description{
Constructs a list of orthogonal Latin square arrays of size v.
}
\details{
Returns at least 3 orthogonal latin square arrays of dimension v. The first and second arrays are the
 rows and columns of a v x v square and the third is a Latin square of size v x v. 
 If v is prime or prime power in the set  4, 8, 16, 32, 64, 128, 9, 27, 81, 25, 49 there
 are v-1 MOLS and \code{orthogLS(v)} will return a total of v+1 arrays. If v = 10 there are two MOLS
 and \code{orthogLS(10)} will give a total of 4 arrays ofsize 10 x 10.
 
 NB If S1 and T1 are mutually orthogonal Latin squares of order n1 and
 S2 and T2 are mutually orthogonal Latin squares of order n2 then the product squares S1xS2
 and T1xT2 are orthogonal to each other and have order n1n2 (not yet implemented)
}
\examples{
## Set of 5 x 5 MOLS
orthogLS(5)

}
\references{
Sailer, M. O. (2013). crossdes: Construction of Crossover Designs. R package version 1.1-1. 
https://CRAN.R-project.org/package=crossdes
}
