% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_tests.R
\name{t_tests}
\alias{t_tests}
\alias{one_sample_t_test_params}
\alias{one_sample_t_test}
\alias{two_sample_t_test}
\alias{paired_samples_t_test}
\title{T-Tests}
\usage{
one_sample_t_test_params(
  sample_mean,
  sample_variance,
  num_samples,
  assumed_mean
)

one_sample_t_test(u, assumed_mean)

two_sample_t_test(u, v)

paired_samples_t_test(u, v)
}
\arguments{
\item{sample_mean}{A single value.}

\item{sample_variance}{A single value.}

\item{num_samples}{A single value.}

\item{assumed_mean}{A single value.}

\item{u}{A numeric vector.}

\item{v}{A numeric vector.}
}
\value{
A two-element numeric vector containing the t-statistic and the p-value.
}
\description{
Functions for T - Tests.
}
\examples{
# One Sample T-Test Parameters
one_sample_t_test_params(sample_mean = 2, sample_variance = 1, num_samples = 30, assumed_mean = 0)
# One Sample T-Test
one_sample_t_test(c(5, 6, 7), assumed_mean = 4)
# Two Sample T-Test
two_sample_t_test(c(5, 6, 7), c(4, 5, 6))
# Paired Samples T-Test
paired_samples_t_test(c(5, 6, 7), c(4, 5, 6))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/t_test.html}{Boost Documentation} for more details on the mathematical background.
}
