% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indirect_proportional_incidence_ratio.R
\name{indirect_proportional_incidence_ratio}
\alias{indirect_proportional_incidence_ratio}
\title{Compute the indirect proportional incidence ratio (pir)}
\usage{
indirect_proportional_incidence_ratio(
  ncan,
  ntot,
  ncanref,
  ntotref,
  ncan.min = 5
)
}
\arguments{
\item{ncan}{integer, (age-specific) number of cancers in the population of interest}

\item{ntot}{integer, (age-specific) total number of cancer the the population of interest}

\item{ncanref}{integer, (age-specific) number of cancers in the reference population}

\item{ntotref}{integer, (age-specific) total number of cancer the the reference of interest}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out

Indirect proportional incidence ratio and associated 95\% confidence interval are computing assuming normal distribution of the pir on the log scale.
pir is a summary statistics that should be computed per group of individuals providing age specific counts.}
}
\value{
a 1 line and 3 column data.frame containing the pir (est) and associated 95\% CI (lci, uci)
}
\description{
Compute the indirect proportional incidence ratio (pir)
}
\examples{
ncan <- 1:10
ntot <- 11:20
ncanref <- 41:50
ntotref <- 251:260
ncan.min <- 5

indirect_proportional_incidence_ratio(ncan, ntot, ncanref, ntotref, ncan.min)
indirect_proportional_incidence_ratio(ncan, ntot, ncanref, ntotref, sum(ncan) + 1)
}
\references{
Boyle P, Parkin DM. Cancer registration: principles and methods. Statistical methods for registries. IARC Sci Publ. 1991;(95):126-58. PMID: 1894318.
}
\concept{summary-stat}
