% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{cbc_compare}
\alias{cbc_compare}
\title{Compare multiple choice experiment designs}
\usage{
cbc_compare(..., metrics = "all", sort_by = "d_error", ascending = NULL)
}
\arguments{
\item{...}{Any number of \code{cbc_design} objects to compare, separated by commas.
Can be named for clearer output (e.g., \verb{random = design1, stochastic = design2}).}

\item{metrics}{Character vector specifying which metrics to compare.
Options: "structure", "efficiency", "balance", "overlap", or "all" (default).
Can specify multiple: \code{c("efficiency", "balance")}}

\item{sort_by}{Character. Metric to sort designs by. Options: "d_error" (default),
"balance", "overlap", "profiles_used", "generation_time", or "none"}

\item{ascending}{Logical. If TRUE, sort in ascending order (lower is better).
If FALSE, sort in descending order (higher is better). Default depends on metric.}
}
\value{
A \code{cbc_comparison} object containing comparison results, printed in
a formatted table.
}
\description{
This function compares multiple CBC designs across key quality metrics
including D-error, balance, overlap, and structural characteristics.
Useful for evaluating different design methods or parameter settings.
}
\examples{
library(cbcTools)

# Create profiles
profiles <- cbc_profiles(
  price = c(1, 2, 3),
  type = c("A", "B", "C"),
  quality = c("Low", "High")
)

# Create different designs
design_random <- cbc_design(
  profiles = profiles,
  method = "random",
  n_alts = 2, n_q = 4
)

design_stochastic <- cbc_design(
  profiles = profiles,
  method = "stochastic",
  n_alts = 2, n_q = 4
)

# Compare designs
cbc_compare(design_random, design_stochastic)

# Named comparison with specific metrics
cbc_compare(
  Random = design_random,
  Stochastic = design_stochastic,
  metrics = c("efficiency", "balance"),
  sort_by = "d_error"
)
}
