% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{int_spec}
\alias{int_spec}
\title{Create an interaction specification for fixed parameters}
\usage{
int_spec(between, value, level = NULL, with_level = NULL)
}
\arguments{
\item{between}{Character vector of length 2 specifying the two attributes to interact}

\item{value}{Numeric. Interaction coefficient value}

\item{level}{Character. For categorical variables, specific level of first attribute}

\item{with_level}{Character. For categorical variables, specific level of second attribute}
}
\value{
An interaction specification list
}
\description{
Create an interaction specification for fixed parameters
}
\examples{
# Continuous * continuous interaction
int_spec(between = c("price", "weight"), value = 0.1)

# Continuous * categorical interactions (must specify categorical level)
int_spec(between = c("price", "type"), with_level = "Fuji", value = 0.15)
int_spec(between = c("price", "type"), with_level = "Gala", value = 0.05)

# Categorical * categorical interactions (must specify both levels)
int_spec(between = c("type", "freshness"),
         level = "Fuji", with_level = "Poor", value = -0.2)
}
