% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunemap-integration.R
\name{ReadImmuneMap}
\alias{ReadImmuneMap}
\alias{read.immap.json}
\alias{parse.immap.json}
\alias{get.immap.tracks}
\title{Read tracks from ImmuneMap}
\usage{
read.immap.json(
  url,
  tracks.url = NULL,
  keep.id = TRUE,
  scale.auto = TRUE,
  scale.t = NULL,
  scale.pos = NULL,
  warn.scaling = TRUE,
  simplify.2D = TRUE,
  warn.celltypes = TRUE,
  split.celltypes = FALSE,
  ...
)

parse.immap.json(url)

get.immap.tracks(
  input,
  keep.id = TRUE,
  scale.t = NULL,
  scale.pos = NULL,
  warn.scaling = TRUE,
  simplify.2D = TRUE
)
}
\arguments{
\item{url}{of the json file to download from immunemap; this should be the url to the
video metadata without the "/tracks" suffix. With this method, the metadata will
be used to automatically scale time to seconds and coordinates to microns if
\code{scale.auto=TRUE}.}

\item{tracks.url}{optional: alternatively, provide directly the url of the tracks (ending with "/tracks"),
    or an url of a local json file with tracks. With this method, scales must be set
manually. If not specified, it is assumed that adding the suffix "/tracks" to the
supplied \code{url} will provide the track data.}

\item{keep.id}{logical: keep track ids from immunemap? If false, new unique ids are
generated. Defaults to \code{TRUE}. If there are no ids in the input json, a warning
will be returned; this can be suppressed by setting keep.id = \code{FALSE}.}

\item{scale.auto}{logical: if \code{TRUE} (the default), scales will be set automatically using
the metadata found in \code{url}. This works only if the \code{url} is given, not
if only \code{tracks.url} is supplied.}

\item{scale.t}{optional: multiply timepoints with constant factor to rescale time.
By default, immunemap returns time in # frames.}

\item{scale.pos}{optional: multiply coordinates with constant factor to rescale lengths.
By default, immunemap measures coordinates in pixels.}

\item{warn.scaling}{logical: if \code{scale.t} and \code{scale.pos} are not set,
   warn the user that units are pixels and #frames instead of microns and min/sec. 
Defaults to \code{TRUE}.}

\item{simplify.2D}{logical: if \code{TRUE} (default), automatically project to 2D when the
z-coordinate has only one value.}

\item{warn.celltypes}{logical: if \code{TRUE} (default), warn when the user is either 
trying to return a single tracks object while the metadata indicates there are 
multiple celltypes in the data, or when the user is trying to set \code{split.celltypes = TRUE} 
when there is only one celltype present.}

\item{split.celltypes}{logical: if \code{TRUE} (default = \code{FALSE}), return not one
tracks object but a list of tracks objects for each celltype in the data (as 
determined from the metadata in the immunemap json).}

\item{...}{additional parameters to be passed to \code{\link{get.immap.metadata}}.}

\item{input}{the output of \code{parse.immap.json} serves as input for \code{get.immap.tracks}}
}
\value{
\code{read.immap.json}  returns a list with:
\item{tracks}{either a single tracks object or a named list of tracks objects per cell type (if \code{split.celltypes = TRUE}}
\item{metadata}{a dataframe with metadata for all the track.ids; this is read from the immunemap json file.}

\code{parse.immap.json} simply returns the R list generated from the input json file.

\code{get.immap.tracks} returns a single tracks object.
}
\description{
Reads tracks from \url{https://immunemap.org} for import into celltrackR. 
This produces both tracks object(s) and a dataframe with metadata.
}
\details{
\code{read.immap.json} internally uses \code{parse.immap.json} to parse the json file,
\code{get.immap.tracks} to extract the tracks, and  \code{\link{get.immap.metadata}}
to read the metadata.
}
\note{
This functionality requires the jsonlite package to be installed.
}
\examples{
\dontrun{
## Read tracks from immunemap online, using the video info for automatic scaling
tr <- read.immap.json( url = "https://api.immunemap.org/video/14" )

## Read tracks and rescale time (.5min/frame) and coordinates (2microns/pixel)
tracksUrl <- "https://api.immunemap.org/video/14/tracks"
tr <- read.immap.json( tracks.url = tracksUrl, scale.auto = FALSE, scale.t = .5, scale.pos = 2 )
}

## Read tracks from a file 
# tr <- read.immap.json( tracks.url = "my-file.json", warn.scaling = FALSE )

}
\seealso{
\code{\link{get.immap.metadata}}.
}
