% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which.R
\name{which_}
\alias{which_}
\title{Memory-efficient alternative to \code{which()}}
\usage{
which_(x, invert = FALSE)
}
\arguments{
\item{x}{A \link{logical} vector.}

\item{invert}{If \code{TRUE}, indices of values that are not \code{TRUE} are returned
(including \code{NA}). If \code{FALSE} (the default), only \code{TRUE} indices are returned.}
}
\value{
An unnamed integer vector.
}
\description{
Exactly the same as \code{which()} but more memory efficient.
}
\details{
This implementation is similar in speed to \code{which()}
but usually more memory efficient.
}
\examples{
library(cheapr)
library(bench)
x <- sample(c(TRUE, FALSE), 1e05, TRUE)
x[sample.int(1e05, round(1e05/3))] <- NA

mark(which_(TRUE), which(TRUE))
mark(which_(FALSE), which(FALSE))
mark(which_(logical()), which(logical()))
mark(which_(x), which(x), iterations = 20)
mark(base = which(is.na(match(x, TRUE))),
     collapse = collapse::whichv(x, TRUE, invert = TRUE),
     cheapr = which_(x, invert = TRUE),
     iterations = 20)

}
