% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{get_clip_ext}
\alias{get_clip_ext}
\title{Setting the clipping extent}
\usage{
get_clip_ext(pnts, radius, extrusion = 1.1)
}
\arguments{
\item{pnts}{One of sf or SpatVector object. Target points of computation.}

\item{radius}{numeric(1). Buffer radius. It is assumed to be in meters}

\item{extrusion}{numeric(1). The extent extrusion factor.
Default is 1.1, meaning that the actual padding is 10 percent
wider than \code{radius}.}
}
\value{
A \code{\link[terra:ext]{terra::ext}} or sfc_POLYGON object of the computation extent.
}
\description{
Return clipping extent with buffer radius.
It assumes the input CRS is projected and linear unit is meters.
}
\seealso{
Other Helper functions: 
\code{\link{datamod}()},
\code{\link{dep_check}()},
\code{\link{dep_switch}()},
\code{\link{par_def_q}()},
\code{\link{reproject_std}()},
\code{\link{reproject_to_raster}()}
}
\author{
Insang Song
}
\concept{Helper functions}
\keyword{internal}
