% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETo.R
\name{ETo}
\alias{ETo}
\alias{ETo.default}
\alias{ETo.data.frame}
\alias{ETo.array}
\alias{ETo.sf}
\title{Reference evapotranspiration}
\usage{
ETo(object, ..., Kc = 1)

\method{ETo}{default}(object, tmin, ..., Kc = 1, lat = NULL, month = NULL)

\method{ETo}{data.frame}(object, day.one, ..., Kc = 1)

\method{ETo}{array}(object, day.one, ..., Kc = 1, lat = NULL, p = 0.27)

\method{ETo}{sf}(object, day.one, ..., Kc = 1, as.sf = TRUE)
}
\arguments{
\item{object}{a numeric vector with the maximum temperature, 
or a data.frame with geographical coordinates (lonlat), 
or an object of class \code{sf} with geometry 'POINT' or 'POLYGON', 
or an \code{array} with two dimensions containing the
maximum and minimum temperature, in that order. See details}

\item{...}{additional arguments passed to methods. See details}

\item{Kc}{a numeric value for the crop factor for water requirement}

\item{tmin}{a numeric vector with the minimum temperature}

\item{lat}{a vector for the latitude (in Decimal degrees), used to compute 
mean daily percentage of annual daytime hours based on the latitude and month.
This is extracted automatically in the \code{sf} method. See details}

\item{month}{an integer for the reference month of daylight percentage}

\item{day.one}{a vector of class \code{Date} or any other object that can be 
coerced to \code{Date} (e.g. integer, character YYYY-MM-DD) for the starting 
day to capture the climate data}

\item{p}{optional if \var{lat} is given, a numeric for the mean daily percentage 
of annual daytime hours (p = 0.27 by default)}

\item{as.sf}{logical, to return an object of class 'sf'}
}
\value{
The evapotranspiration in mm/day
}
\description{
Reference evapotranspiration using the Blaney-Criddle method. This is general  
theoretical method used when no measured data on pan evaporation 
is available locally.
}
\details{
When \var{lat} is provided, it is combined with the month provided in 
 \var{day.one} to call for the system data \code{daylight} to find
 the correct value for \var{p} which represents the daily percentage
 of daytime hours in the given month and latitude. Otherwise \var{p} is set 
 to 0.27 as default.
 
The \code{array} method assumes that \var{object} contains climate data available 
 in your R section; this requires an array with two dimensions, 1st dimension 
 contains the day temperature and 2nd dimension the night temperature, 
 see help("temp_dat", package = "climatrends") for an example on input structure.

The \code{data.frame} method and the \code{sf} method assumes that the climate data
 will be fetched from a remote (cloud) source that be adjusted using the argument 
 \var{data.from}.

Additional arguments:

\code{last.day}: an object (optional to \var{span}) of class \code{Date} or
 any other object that can be coerced to \code{Date} (e.g. integer, character 
 YYYY-MM-DD) for the last day of the time series
 
\code{span}: an integer (optional to \var{last.day}) or a vector with 
 integers (optional if \var{last.day} is given) for the length of 
 the time series to be captured

\code{data.from}: character for the source of climate data. Current remote data 
 is: 'nasapower'

\code{pars}: character vector for the temperature data to be fetched. If 
 \code{data.from} is 'nasapower'. The temperature can be adjusted to 2 m, the default,
 c("T2M_MAX", "T2M_MIN") or 10 m c("T10M_MAX", "T10M_MIN") 

\code{days.before}: optional, an integer for the number of days before 
 \var{day.one} to be included in the timespan.
}
\examples{
# the default method
set.seed(78)
tmax <- runif(50, 37, 47)
set.seed(79)
tmin <- runif(50, 31, 34)

ETo(tmax, tmin, lat = 22, month = 10)

###############################################

# the array method
data("temp_dat", package = "climatrends")

ETo(temp_dat, 
    day.one = "2013-10-28",
    span = 10,
    Kc = 0.92)
    
\donttest{
#######################################
library("nasapower")
library("sf")
data("lonlatsf", package = "climatrends")

ETo(lonlatsf,
    day.one = "2015-04-22",
    last.day = "2015-06-22",
    pars = c("T10M_MAX", "T10M_MIN"))
}
}
\references{
Brouwer C. & Heibloem M. (1986). Irrigation water management: 
Irrigation water needs. Food and Agriculture Organization of The 
United Nations, Rome, Italy. 
\url{http://www.fao.org/3/S2022E/s2022e00.htm}
}
\seealso{
Other temperature functions: 
\code{\link{GDD}()},
\code{\link{crop_sensitive}()},
\code{\link{temperature}()}
}
\concept{temperature functions}
