% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{cocoOptim}
\alias{cocoOptim}
\title{Optimizer of nonstationary spatial models}
\usage{
cocoOptim(coco.object, boundaries = list(), 
ncores = parallel::detectCores(), optim.control, optim.type)
}
\arguments{
\item{coco.object}{(\code{S4}) a \link{coco} object.}

\item{boundaries}{(\code{list}) if provided, a list with lower, init, and upper values, as the one provided by \link{getBoundaries}. Otherwise,
it is computed based on \link{getBoundaries} with global lower and upper values -2 and 2.}

\item{ncores}{(\code{integer}) number of threads for the optimization routine.}

\item{optim.control}{(\code{list}) list with settings to be passed to the optimParallel function [2].}

\item{optim.type}{(\code{character}) Optimization approach: whether \code{"mle"} for classical Maximum Likelihood approach,
or \code{"pmle"} to factor out the spatial trend (when handling \code{"dense"} coco objects), or
to factor out the global marginal standard deviation parameter (when considering \code{"sparse"} coco objects).}
}
\value{
(\code{S4}) An optimized S4 object of class \code{coco}.
}
\description{
Estimation of the spatial model parameters based on the L-BFGS-B optimizer [1].
}
\details{
Current implementation only allows a single realization for \code{"pmle"} \code{optim.type}.
}
\examples{
\dontrun{
model.list <- list('mean' = 0,
                   'std.dev' = formula( ~ 1 + cov_x + cov_y),
                   'scale' = formula( ~ 1 + cov_x + cov_y),
                   'aniso' = 0,
                   'tilt' = 0,
                   'smooth' = 3/2,
                   'nugget' = -Inf)
                   
coco_object <- coco(type = 'dense',
                    data = holes[[1]][1:100,],
                    locs = as.matrix(holes[[1]][1:100,1:2]),
                    z = holes[[1]][1:100,]$z,
                    model.list = model.list)
                    
optim_coco <- cocoOptim(coco_object,
boundaries = getBoundaries(coco_object,
lower.value = -3, 3))

plot(optim_coco)

print(optim_coco)

getEstims(optim_coco)
}

}
\references{
[1] Byrd, Richard H., et al. \emph{"A limited memory algorithm for bound constrained optimization."}
SIAM Journal on scientific computing 16.5 (1995): 1190-1208.

[2] Gerber, Florian, and Reinhard Furrer. \emph{"optimParallel: An R package providing a parallel version of the L-BFGS-B optimization method."}
R Journal 11.1 (2019): 352-358.
}
\seealso{
[\link[optimParallel]{optimParallel}]
}
\author{
Federico Blasi
}
