% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_roche_summary.R
\name{tbl_roche_summary}
\alias{tbl_roche_summary}
\title{Roche Summary Table}
\usage{
tbl_roche_summary(
  data,
  by = NULL,
  label = NULL,
  statistic = list(gtsummary::all_continuous() ~ c("{mean} ({sd})", "{median}",
    "{min} - {max}"), gtsummary::all_categorical() ~ "{n} ({p}\%)"),
  digits = NULL,
  type = NULL,
  value = NULL,
  nonmissing = c("no", "always", "ifany"),
  nonmissing_text = "n",
  nonmissing_stat = "{N_nonmiss}",
  sort = gtsummary::all_categorical(FALSE) ~ "alphanumeric",
  percent = c("column", "row", "cell"),
  include = everything()
)
}
\arguments{
\item{data}{(\code{data.frame})\cr A data frame.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}.}

\item{label}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Used to override default labels in summary table, e.g. \code{list(age = "Age, years")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{statistic}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies summary statistics to display for each variable.  The default is
\code{list(all_continuous() ~ "{median} ({p25}, {p75})", all_categorical() ~ "{n} ({p}\%)")}.
See below for details.}

\item{digits}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies how summary statistics are rounded. Values may be either integer(s)
or function(s). If not specified, default formatting is assigned
via \code{assign_summary_digits()}. See below for details.}

\item{type}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies the summary type. Accepted value are
\code{c("continuous", "continuous2", "categorical", "dichotomous")}.
If not specified, default type is assigned via
\code{assign_summary_type()}. See below for details.}

\item{value}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies the level of a variable to display on a single row.
The gtsummary type selectors, e.g. \code{all_dichotomous()}, cannot be used
with this argument. Default is \code{NULL}. See below for details.}

\item{nonmissing, nonmissing_text, nonmissing_stat}{Arguments dictating how and if missing values are presented:
\itemize{
\item \code{nonmissing}: must be one of \code{c("always", "ifany", "no")}
\item \code{nonmissing_text}: string indicating text shown on non-missing row. Default is \code{"n"}
\item \code{nonmissing_stat}: statistic to show on non-missing row. Default is \code{"{N_nonmiss}"}.
Possible values are \code{N_nonmiss}, \code{N_miss}, \code{N_obs}, \code{p_nonmiss} \code{p_miss}.
}}

\item{sort}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies sorting to perform for categorical variables.
Values must be one of \code{c("alphanumeric", "frequency")}.
Default is \code{all_categorical(FALSE) ~ "alphanumeric"}.}

\item{percent}{(\code{string})\cr
Indicates the type of percentage to return.
Must be one of \code{c("column", "row", "cell")}. Default is \code{"column"}.

In rarer cases, you may need to define/override the typical denominators.
In these cases, pass an integer or a data frame. Refer to the
\code{\link[cards:ard_tabulate]{?cards::ard_tabulate(denominator)}} help file for details.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}
}
\value{
a 'gtsummary' table
}
\description{
This is a thin wrapper of \code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}} with the following differences:
\itemize{
\item Default summary type for continuous variables is \code{'continuous2'}.
\item Number of non-missing observations, when requested, is added for each variable
and placed on the row under the variable label/header.
\item The \verb{tbl_summary(missing*)} arguments have been renamed to
\verb{tbl_roche_summary(nonmissing*)} with updated default values.
\item The default footnotes from \code{tbl_summary()} are removed.
\item Cells with \code{"0 (0.0\%)"} are converted to \code{"0"} with \code{gtsummary::modify_post_fmt_fun()}.
}
}
\examples{
# Example 1 ----------------------------------
trial |>
  tbl_roche_summary(
    by = trt,
    include = c(age, grade),
    nonmissing = "always"
  ) |>
  add_overall()
}
