% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmate.R
\name{check_probability}
\alias{check_probability}
\alias{assert_probability}
\alias{test_probability}
\alias{expect_probability}
\title{Check if an argument is a single probability value}
\usage{
check_probability(x, bounds_closed = TRUE)

assert_probability(
  x,
  bounds_closed = TRUE,
  .var.name = checkmate::vname(x),
  add = NULL
)

test_probability(x, bounds_closed = TRUE)

expect_probability(x, bounds_closed = TRUE, info = NULL, label = vname(x))
}
\arguments{
\item{x}{(\code{number})\cr a single value to check.}

\item{bounds_closed}{(\code{logical})\cr should bounds be closed? This can be a
scalar or vector of length two. If it is a scalar, then its value applies
equally to lower bound \eqn{0} and upper bound \eqn{1}. If this is a vector
with two flags, the first flag corresponds to the lower bound \eqn{0}
only, and the second to the upper bound \eqn{1} only.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}
}
\value{
\code{TRUE} if successful, otherwise a string with the error message.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Check if a given value represents a probability, that is a number within
(0, 1) interval, that can optionally be closed at any side.
}
\examples{
check_probability(0.5)
check_probability(0, bounds_closed = FALSE)
check_probability(0, bounds_closed = c(FALSE, TRUE))
}
\seealso{
\code{\link{assertions}} for more details.
}
