% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dapply}
\alias{dapply}
\title{Apply a Function to Subsets of Data Frame.}
\usage{
dapply(df, f, FUN, ...)
}
\arguments{
\item{df}{(\verb{data frame})\cr data set to be divided into groups.}

\item{f}{(\code{factor} or \code{formula} or \code{list})\cr a factor in the sense that
\code{as.factor(f)} defines the grouping, or a \code{list} of such factors in which
case their interaction is used for the grouping. \code{f} can also be a formula
of the form \code{~ g1 + ... + gk} to split by the interaction of the variables
\verb{g1, ..., gk}. This parameter is passed directly into \code{\link[=split]{split()}} function.}

\item{FUN}{(\code{function})\cr the function to be applied to each subset of \code{df}
defined by \code{f}.}

\item{...}{parameters passed to \code{\link[=lapply]{lapply()}}, which is used when applying a
function \code{FUN} over groups defined by \code{f}.}
}
\value{
The \code{\link{data.frame}} object with results from \code{FUN}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{dapply} splits the data \code{df} into the subsets defined by \code{f},
and applies function \code{FUN} to each of the subset.
All the results are row-binded and returned as \code{data.frame} object.
}
\examples{
df <- data.frame(
  dose = c(0.1, 6, 6, 5, 0.1, 5, 6, 6),
  cohort = c("B", "B", "B", "A", "A", "A", "B", "B")
)

dapply(
  df,
  f = ~cohort,
  FUN = function(coh) {
    data.frame(my_cohort = coh$cohort[1], my_max = max(coh$dose))
  }
)

dapply(
  df,
  f = ~cohort,
  FUN = function(coh) {
    coh$dose <- sort(coh$dose, decreasing = TRUE)
    coh
  }
)
}
