% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{h_format_number}
\alias{h_format_number}
\title{Conditional Formatting Using C-style Formats}
\usage{
h_format_number(x, digits = 5, prefix = "", suffix = "")
}
\arguments{
\item{x}{(\code{number})\cr a number to be formatted.}

\item{digits}{(\code{function})\cr the desired number of significant digits.}

\item{prefix}{(\code{string})\cr a prefix to be added in front of the formatted
number.}

\item{suffix}{(\code{string})\cr a suffix to be appended after the formatted
number.}
}
\value{
Either formatted \code{x} as \code{string} or unchanged \code{x} if the
formatting condition is not met.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This helper function conditionally formats a number with \code{\link[=formatC]{formatC()}}
function using \code{"E"} format and specific number of digits as given by the
user. A number is formatted if and only if its absolute value is less than
\code{0.001} or greater than \code{10000}. Otherwise, the number is not formatted.
Additionally, custom prefix or suffix can be appended to character string
with formatted number, so that the changes are marked.
}
\note{
This function was primarily designed as a helper for
\code{\link[=h_jags_write_model]{h_jags_write_model()}} function.
}
\examples{
h_format_number(50000)
h_format_number(50000, prefix = "P", suffix = "S")
}
