% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\name{probFunction}
\alias{probFunction}
\alias{probFunction,GeneralModel-method}
\alias{probFunction-GeneralModel}
\alias{probFunction,ModelTox-method}
\alias{probFunction-ModelTox}
\alias{probFunction,LogisticLogNormalOrdinal-method}
\alias{probFunction-LogisticLogNormalOrdinal}
\title{Getting the Prob Function for a Given Model Type}
\usage{
probFunction(model, ...)

\S4method{probFunction}{GeneralModel}(model, ...)

\S4method{probFunction}{ModelTox}(model, ...)

\S4method{probFunction}{LogisticLogNormalOrdinal}(model, grade, ...)
}
\arguments{
\item{model}{(\code{GeneralModel} or \code{ModelTox})\cr the model.}

\item{...}{model specific parameters.}

\item{grade}{(\code{integer})\cr the toxicity grade for which the dose function is
required}
}
\value{
A \code{\link[=prob]{prob()}} function that computes toxicity probabilities.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A function that returns a \code{\link[=prob]{prob()}} function that computes the toxicity
probabilities for a given dose level, based on the model specific parameters.
}
\section{Functions}{
\itemize{
\item \code{probFunction(GeneralModel)}: 

\item \code{probFunction(ModelTox)}: 

\item \code{probFunction(LogisticLogNormalOrdinal)}: 

}}
\examples{
my_model <- LogisticLogNormal(
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
  ref_dose = 50
)

prob_fun <- probFunction(my_model, alpha0 = 2, alpha1 = 3)
prob_fun(30)
ordinal_data <- .DefaultDataOrdinal()
ordinal_model <- .DefaultLogisticLogNormalOrdinal()
opts <- .DefaultMcmcOptions()
samples <- mcmc(ordinal_data, ordinal_model, opts)

probFunction(
  ordinal_model,
  grade = 2L,
  alpha2 = samples@data$alpha1,
  beta = samples@data$beta
)(50)
}
\seealso{
\code{\link[=prob]{prob()}}, \code{\link[=doseFunction]{doseFunction()}}.
}
