% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Lemna.R
\name{Lemna_Schmitt}
\alias{Lemna_Schmitt}
\alias{LemnaSchmittScenario-class}
\alias{Lemna_SchmittThold}
\title{Lemna model (Schmitt et al. 2013)}
\usage{
Lemna_Schmitt(param, init)

Lemna_SchmittThold(param, init)
}
\arguments{
\item{param}{optional named \code{list} or \code{vector} of model parameters}

\item{init}{optional named numeric \code{vector} of initial state values}
}
\value{
an S4 object of type \linkS4class{LemnaSchmittScenario}
}
\description{
The model is a mechanistic combined toxicokinetic-toxicodynamic (TK/TD) and
growth model for the aquatic macrophytes \emph{Lemna spp.}
The model simulates the development of \emph{Lemna} biomass under laboratory and
environmental conditions and was developed by Schmitt \emph{et al.} (2013). Growth
of the \emph{Lemna} population is simulated on basis of photosynthesis and respiration
rates which are functions of environmental conditions.
The toxicodynamic sub-model describes the effects of growth-inhibiting
substances by a respective reduction in the photosynthesis rate based on
internal concentrations.
}
\details{
Constructors to ease creation of scenarios based on the \emph{Lemna} model by
Schmitt \emph{et al.} (2013).
A variant of this \emph{Lemna} model, \code{Lemna_SchmittThold()}, provides an additional
cumulative exposure threshold parameter. The Lemna biomass stops growing
if the integral of exposure over time exceeds the threshold. The integral
of exposure is internally accounted for by an additional state variable
\code{AUC} (Area Under Curve).
}
\section{Functions}{
\itemize{
\item \code{Lemna_SchmittThold()}: model variant with cumulative exposure threshold

}}
\section{State variables}{

The following list describes the default names and standard units of the model's
state variables:
\itemize{
\item BM, g_dw/m2, dry weight biomass per square meter
\item E, -, effect [0,1]
\item M_int, ug, internal toxicant mass
\item AUC, ug/L, cumulative exposure (\strong{only} for \code{LemnaThreshold} model)
}

Biomass (BM) and internal toxicant mass (M_int) are initialized to zero by
default. See \code{\link[=set_init]{set_init()}} on how to set the initial states.
}

\section{Model parameters}{

The following model parameters are required:
\itemize{
\item Fate and biomass
\itemize{
\item k_phot_fix, logical, TRUE then k_phot_max is not changed by environmental factors, else FALSE
\item k_phot_max, 1/d, maximum photosynthesis rate
\item k_resp, 1/d, respiration rate
\item k_loss, 1/d, rate of loss (e.g. flow rate)
\item mass_per_frond, g_dw/frond, dry weight per frond
\item BMw2BMd, g_fw/g_dw, Fresh weight/dry weight
}
\item Effect
\itemize{
\item Emax, -, maximum effect [0,1]
\item EC50, ug/L, midpoint of effect curve
\item b, -, slope of effect curve
}
\item Toxicokinetics
\itemize{
\item P_up, cm/d, Permeability for uptake
\item AperBM, cm2/g_dw, A_leaf / d_leaf = 1/d_leaf (for circular disc, d=0.05 cm)
\item Kbm, -, Biomass(fw) : water partition coefficient
\item P_Temp, logical, TRUE to enable temperature dependence of cuticle permeability, else FALSE
\item MolWeight, g/mol, Molmass of molecule (determines Q10_permeability)
}
\item Temperature dependence
\itemize{
\item Tmin, deg C, minimum temperature for growth
\item Tmax, deg C, maximum temperature for growth
\item Topt, deg C, optimal temperature for growth
\item t_ref, deg C, reference temperature for respiration rate
\item Q10, -, temperature dependence factor for respiration rate
}
\item Light dependence
\itemize{
\item k_0, 1/d, light dependence: intercept of linear part
\item a_k, (1/d)/(kJ/m2.d), light dependence: slope of linear part
}
\item Phosphorus dependence (Hill like dep.)
\itemize{
\item C_P, mg/L, phosphorus concentration in water
\item CP50, mg/L, phosphorus conc. where growth rate is halfed
\item a_p, -, Hill coefficient
\item KiP, mg/L, p-inhibition constant for very high p-conc.
}
\item Nitrogen dependence (Hill like dep.)
\itemize{
\item C_N, mg/L, nitrogen concentration in water
\item CN50, mg/L, n-conc. where growth rate is halfed
\item a_N, -, Hill coefficient
\item KiN, mg/L, n-inhibition constant for very high p-conc.
}
\item Density dependence
\itemize{
\item BM50, g_dw/m2, cut off BM
}
}

The \code{Lemna_SchmittThold} model requires the following additional parameter:
\itemize{
\item threshold, ug/L, cumulative exposure threshold
}
}

\section{Forcings}{

Besides exposure, the Lemna model requires two environmental properties as
time-series input: global radiation (\code{rad}, kJ/m2.d) and temperature (\code{temp}, deg C).
Forcings time-series are represented by \code{data.frame} objects consisting of two
columns. The first for time and the second for the environmental factor in question.

Entries of the \code{data.frame} need to be ordered chronologically. A time-series
can consist of only a single row; in this case it will represent constant
environmental conditions. See \link{scenarios} for more details.
}

\section{Effects}{

Supported effect endpoints include \emph{BM} (biomass) and \emph{r} (average
growth rate during simulation). The effect on biomass is calculated from
the last state of a simulation. Be aware that endpoint \emph{r} is incompatible
with frond transfers.
}

\section{Simulation output}{

Simulation results will contain two additional columns besides state variables:
\itemize{
\item C_int, ug/L, internal concentration of toxicant
\item FrondNo, -, number of fronds
}

It is possible to amend the output of \code{\link[=simulate]{simulate()}} with additional model
quantities that are not state variables, for e.g. debugging purposes or to
analyze model behavior. To enable or disable additional outputs, use the
optional argument \code{nout} of \code{\link[=simulate]{simulate()}}, see examples below. \code{nout=1}
enables reporting of internal concentration (C_int), \code{nout=14} enables all
additional outputs, and \code{nout=0} will disable additional outputs.

The available output levels are as follows:
\itemize{
\item \code{nout=1}
\itemize{
\item \code{C_int}, internal concentration (ug/L)
}
\item \code{nout=2}
\itemize{
\item \code{FrondNo}, number of fronds (-)
}
\item \code{nout=3}
\itemize{
\item \code{C_int_u}, unbound internal concentration (ug/l)
}
\item \code{nout=8}, growth and TK/TD
\itemize{
\item \code{BM_fresh}, fresh weight biomass (g_fw/m2)
\item \code{k_photo_eff}, current photosynthesis rate (1/d)
\item \code{k_resp_eff}, current respiration rate (1/d)
\item \code{f_Eff}, toxic effect factor (-)
\item \code{P_up_eff}, current permeability for uptake (cm/d)
}
\item \code{nout=11}, environmental factors
\itemize{
\item \code{actConc}, current toxicant concentration in surrounding medium (ug/L)
\item \code{actTemp}, current environmental temperature (deg C)
\item \code{actRad}, current environmental radiation (kJ/m2.d)
}
\item \code{nout=14}, derivatives
\itemize{
\item \verb{d BM/dt}, current change in state variable BM
\item \verb{d E/dt}, current change in effect
\item \verb{d M_int/dt}, current change in internal toxicant mass
}
}
}

\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. Lemna effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

Any transfer time point must also be an output time point. If a transfer
occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that in order to use transfers at regular
intervals, the simulation must start at time point zero.
}

\references{
Schmitt W., Bruns E., Dollinger M., and Sowig P., 2013:
\emph{Mechanistic TK/TD-model simulating the effect of growth inhibitors on
Lemna populations}. Ecol Model 255, pp. 1-10. \doi{10.1016/j.ecolmodel.2013.01.017}
}
\seealso{
\link{Lemna-models}, \link{Macrophyte-models}, \link{Transferable}, \link{Scenarios}

Other Lemna models: 
\code{\link{Lemna-models}},
\code{\link{Lemna_SETAC}()}

Other macrophyte models: 
\code{\link{Lemna_SETAC}()},
\code{\link{Macrophyte-models}},
\code{\link{Myrio}()},
\code{\link{Myrio_log}()}
}
\concept{Lemna models}
\concept{macrophyte models}
