% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{survival}
\alias{survival}
\title{Survival rate}
\usage{
survival(scenario, ...)
}
\arguments{
\item{scenario}{an \code{EffectScenario} to simulate}

\item{...}{additional parameters passed on to \code{\link[=simulate]{simulate()}}}
}
\value{
a \code{data.frame} containing simulation results
}
\description{
\emph{Deprecated function}. Derives the survival rate of individuals for
\emph{Reduced GUTS} models. Was replaced by \code{\link[=simulate]{simulate()}}.
}
\details{
The survival rate describes the survival probability at each
time point. The function simulates the \emph{GUTS} scenario and appends a column
\code{survival} to the simulation result. A value of one (\code{1.0}) denotes that
all individuals survive. A value of zero (\code{0.0}) denotes that no individuals
survived.

Only available for \emph{Reduced GUTS} models, see \link{GUTS-RED-models}.
The equations were described by EFSA (2018).
}
\examples{
# calculate survival rate
minnow_it \%>\% survival()

# plot survival over time based on a random exposure profile
minnow_sd \%>\%
  set_exposure(data.frame(t=1:100, c=runif(100)*10)) \%>\%
  survival() -> df
plot(df$time, df$survival, "l")
}
\references{
EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, et al., 2018: \emph{Scientific Opinion on the
state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect models for
regulatory risk assessment of pesticides for aquatic organisms}. EFSA Journal 2018;
16(8):5377, 188 pp. \doi{10.2903/j.efsa.2018.5377}
}
\seealso{
\link{GUTS-RED-models}
}
