% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epx.R
\name{epx_mtw}
\alias{epx_mtw}
\title{Calculate EPx values for a series of moving time window}
\usage{
epx_mtw(
  x,
  level = c(10, 50),
  factor_cutoff = 1000,
  window_length = 7,
  window_interval = 1,
  ...
)
}
\arguments{
\item{x}{a \link{scenario}}

\item{level}{The target effect level of the effect, ie. the x of EPx.}

\item{factor_cutoff}{above which cutoff is the EPx is not relevant}

\item{window_length}{the length of the moving time window}

\item{window_interval}{the interval that the moving time window moves}

\item{...}{arguments passed to \code{epx}}
}
\value{
a tibble with five columns
\itemize{
\item window.start
\item window.end
\item endpoint
\item level
\item EPx
}
}
\description{
Calls \code{epx()} to calculate the EPx value (i.e. the multiplication factors of
an exposure profile that cause x\% of effect) for moving windows with length
\code{window_length} that move timesteps defined by \code{window_interval}.
}
\examples{
metsulfuron \%>\%
  set_window(length=7, interval=1) \%>\%
  epx_mtw()
}
