% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_tag}
\alias{set_tag}
\title{Set a tag}
\usage{
set_tag(x, tag)
}
\arguments{
\item{x}{(vector of) \code{EffectScenario} objects}

\item{tag}{vector of \code{character}}
}
\value{
(vector of) modified \code{EffectScenario} objects
}
\description{
Sets the user-defined, custom tag of a scenario. Tags
can be helpful to quickly distinguish scenarios of the same model type.
}
\examples{
# set a custom tag
myscenario <- GUTS_RED_SD() \%>\% set_tag("My Custom Tag")

# returns `My Custom Tag`
get_tag(myscenario)

# the tag also appears in the scenario overview
myscenario
}
\seealso{
\code{\link[=get_tag]{get_tag()}}
}
