% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processors.R
\name{list_processor_types}
\alias{list_processor_types}
\title{List available processor types}
\usage{
list_processor_types(
  full_list = FALSE,
  proj_id = get_project_id(),
  loc = "eu",
  token = dai_token()
)
}
\arguments{
\item{full_list}{boolean.}

\item{proj_id}{a GCS project id.}

\item{loc}{a two-letter region code; "eu" or "us".}

\item{token}{an authentication token generated by
\code{dai_auth()} or another auth function.}
}
\value{
list or character vector
}
\description{
List available processor types
}
\details{
Retrieves information about the processors that
can be created in the current project. With
\code{full_list = TRUE} it returns a list with detailed
information about each processor. With \code{full_list = FALSE}
it returns a character vector with just the processor names.
For more information about processors, see the
Google Document AI documentation at
\url{https://cloud.google.com/document-ai/docs/}.
}
\examples{
\dontrun{
avail_short <- list_processor_types()
avail_long <- list_processor_types(full_list = TRUE)
}
}
